/*
 * Decompiled with CFR 0.152.
 */
package DictPKG;

import DictPKG.Dict;
import DictPKG.HelpFunctions;
import GeneralLibs.CustomInputStream;
import GeneralLibs.GeneralUtils;

public class CCompressTxt
extends HelpFunctions {
    private short[] mirtable = new short[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};
    Dict.CompKey KeySrc;
    Dict.CompKey KeyDes;
    Dict.WordItem[] WordItemsDes;
    Dict.LetterItem[] LetterItemsSrc = new Dict.LetterItem[256];
    Dict.LetterItem[] LetterItemsDes = new Dict.LetterItem[256];

    int Analyze(byte[] buff, int nSize, Dict.CompKey[] KeyS, Dict.CompKey[] KeyD, boolean bIsArabicSrc, boolean bIsArabicDes) {
        int i;
        int nCharsTemp;
        this.WordItemsDes = new Dict.WordItem[Dict.MAX_WORDS];
        int[] nWord = new int[1];
        for (int nChars = 0; nChars < nSize; nChars += nCharsTemp) {
            nChars += this.CountLetters(buff, nChars, nSize - nChars, this.LetterItemsSrc, Dict.COUNT_FLAG, (byte)59, bIsArabicSrc);
            nCharsTemp = this.CountLetters(buff, nChars, nSize - nChars, this.LetterItemsDes, Dict.COUNT_FLAG, (byte)10, bIsArabicDes);
            this.CountWords(buff, nChars, this.WordItemsDes, nCharsTemp, nWord);
        }
        Dict.QSort WordSrt = new Dict.QSort(new Dict.WordCompareSize());
        WordSrt.sort(this.WordItemsDes, 0, nWord[0]);
        Dict.QSort LetterSrt = new Dict.QSort(new Dict.LetterCountCompare());
        WordSrt.sort(this.LetterItemsSrc, 1, 255);
        WordSrt.sort(this.LetterItemsDes, 1, 255);
        int nCharsSrc = 0;
        int nCharsDes = 0;
        this.KeySrc.byKeysCount = 1;
        this.KeyDes.byKeysCount = 1;
        for (i = 0; i < 256; ++i) {
            this.LetterItemsSrc[i].newID = this.GetCharID((byte)i, this.LetterItemsSrc);
            this.KeySrc.keys[i] = this.LetterItemsSrc[i].byInd;
            if (this.KeySrc.keys[i] != 0) {
                this.KeySrc.byKeysCount = (byte)(this.KeySrc.byKeysCount + 1);
            }
            if (this.LetterItemsSrc[i].nCount != 0) {
                ++nCharsSrc;
            }
            this.LetterItemsDes[i].newID = this.GetCharID((byte)i, this.LetterItemsDes);
            this.KeyDes.keys[i] = this.LetterItemsDes[i].byInd;
            if (this.KeyDes.keys[i] != 0) {
                this.KeyDes.byKeysCount = (byte)(this.KeyDes.byKeysCount + 1);
            }
            if (this.LetterItemsDes[i].nCount == 0) continue;
            ++nCharsDes;
        }
        int nBitsSrc = 0;
        int nBitsDes = 0;
        boolean ifCond = true;
        i = 0;
        this.KeySrc.byMark = (byte)-128;
        this.KeySrc.byMask = 0;
        nBitsSrc = 8;
        while (i < 7 && (nCharsSrc & this.KeySrc.byMark) == 0) {
            this.KeySrc.byMask = (byte)(this.KeySrc.byMask | this.KeySrc.byMark);
            ++i;
            this.KeySrc.byMark = (byte)(this.KeySrc.byMark >> 1);
            --nBitsSrc;
        }
        ifCond = true;
        i = 0;
        this.KeyDes.byMark = (byte)-128;
        this.KeyDes.byMask = 0;
        nBitsDes = 8;
        while (i < 7 && (nCharsDes & this.KeyDes.byMark) == 0) {
            this.KeyDes.byMask = (byte)(this.KeyDes.byMask | this.KeyDes.byMark);
            ++i;
            this.KeyDes.byMark = (byte)(this.KeyDes.byMark >> 1);
            --nBitsDes;
        }
        if (this.KeySrc.byMark < 128) {
            this.KeySrc.byMark = (byte)(this.KeySrc.byMark << 1);
            this.KeySrc.byMask = (byte)(this.KeySrc.byMask & ~this.KeySrc.byMark);
            ++nBitsSrc;
        }
        if (this.KeyDes.byMark < 128) {
            this.KeyDes.byMark = (byte)(this.KeyDes.byMark << 1);
            this.KeyDes.byMask = (byte)(this.KeyDes.byMask & ~this.KeyDes.byMark);
            ++nBitsDes;
        }
        this.KeySrc.charCount = (byte)nCharsSrc;
        this.KeyDes.charCount = (byte)nCharsDes;
        this.KeySrc.nBits = (byte)nBitsSrc;
        this.KeyDes.nBits = (byte)nBitsDes;
        this.KeySrc.nCBits = (byte)Dict.COMPRESSED_BITS;
        this.KeyDes.nCBits = (byte)Dict.COMPRESSED_BITS;
        this.KeySrc.nCMask = (byte)Dict.COMPRESSED_MASK;
        this.KeyDes.nCMask = (byte)Dict.COMPRESSED_MASK;
        this.KeySrc.nShift = (byte)Dict.COMPRESSED_ENTRIES;
        this.KeyDes.nShift = (byte)Dict.COMPRESSED_ENTRIES;
        int nOffset = 0;
        this.KeySrc.byWordsCount = 0;
        this.KeyDes.byWordsCount = (byte)(this.KeyDes.byMark - (byte)nCharsDes);
        for (i = 0; i < this.KeyDes.byMark - nCharsDes; ++i) {
            this.KeyDes.wordsOffsets[i] = (short)nOffset;
            CCompressTxt.strncpyByte(this.KeyDes.words, nOffset, this.WordItemsDes[i].pt, 0, this.WordItemsDes[i].nWordSize);
            this.KeyDes.words[nOffset + this.WordItemsDes[i].nWordSize] = 0;
            nOffset += this.WordItemsDes[i].nWordSize + 1;
        }
        this.KeyDes.wordsOffsets[i] = (short)nOffset;
        this.KeySrc.liLetters = this.LetterItemsSrc;
        this.KeyDes.liLetters = this.LetterItemsDes;
        KeyS[0] = this.KeySrc;
        KeyD[0] = this.KeyDes;
        return 1;
    }

    byte GetCharID(byte c, Dict.LetterItem[] LetterItem2) {
        for (int i = 0; i < 256; ++i) {
            if (LetterItem2[i].byInd != c) continue;
            return (byte)i;
        }
        return (byte)Dict.INVALID_CHAR;
    }

    boolean iscntrl(int iTest) {
        return iTest >= 0 && iTest >= 31 || iTest == 127;
    }

    boolean isalpha(int iTest) {
        if (iTest >= 97 && iTest <= 122) {
            return true;
        }
        return iTest >= 65 && iTest <= 90;
    }

    int CountLetters(byte[] buff, int iIndex, int nSize, Dict.LetterItem[] liLetters, int flag, byte byBreakChar, boolean bIsArabic) {
        int i = 0;
        if ((flag & Dict.CLEAR_COUNTS) != 0) {
            for (i = iIndex; i < nSize; ++i) {
                if ((flag & Dict.SKIP_CONTROL) != 0 && this.iscntrl(buff[i])) continue;
                if ((flag & Dict.INCLUDE_LATIN) != 0) {
                    if (this.isalpha(buff[i])) {
                        if ((flag & Dict.CONVERT_2LOWER) != 0) {
                            buff[i] = (byte)Character.toLowerCase((char)buff[i]);
                        }
                        if (0 == liLetters[buff[i]].nCount) {
                            liLetters[buff[i]].byInd = buff[i];
                        }
                        ++liLetters[buff[i]].nCount;
                    } else if ((flag & Dict.INCLUDE_SYMBOLS) != 0 && buff[i] < 128) {
                        if (this.isalpha(buff[i])) {
                            if (0 == liLetters[buff[i]].nCount) {
                                liLetters[buff[i]].byInd = buff[i];
                            }
                            ++liLetters[buff[i]].nCount;
                        } else if ((flag & Dict.INCLUDE_ARABIC) != 0) {
                            if (buff[i] >= 128) {
                                if (bIsArabic && (flag & Dict.EXCLUDE_DIAC) != 0 && buff[i] >= 240) {
                                    return 0;
                                }
                                if (0 == liLetters[buff[i]].nCount) {
                                    liLetters[buff[i]].byInd = buff[i];
                                }
                                ++liLetters[buff[i]].nCount;
                            } else {
                                return 0;
                            }
                        }
                    }
                }
                if (buff[i] == byBreakChar) break;
            }
        }
        return i + 1;
    }

    void CountWords(byte[] buff, int iIndex, Dict.WordItem[] CSA, int nSize, int[] nWord) {
        byte[] pt = null;
        int addSpace = 0;
        int j = 0;
        for (int i = iIndex; i < nSize; ++i) {
            if (this.isalpha(buff[i]) || buff[i] >= 193 && buff[i] < 254) {
                if (pt == null) {
                    pt = new byte[buff.length - i];
                    CCompressTxt.strncpyByte(pt, 0, buff, i, buff.length - i + 1);
                    j = i;
                }
                buff[i] = (byte)Character.toLowerCase((char)buff[i]);
                continue;
            }
            if (pt == null || i <= j) continue;
            addSpace = buff[i] == 32 ? 1 : 0;
            this.InsertWord(CSA, pt, i - j + addSpace, nWord);
            pt = null;
        }
    }

    void InsertWord(Dict.WordItem[] CSA, byte[] CStr, int n, int[] nWord) {
        int iLow = 0;
        int iHigh = nWord[0] - 1;
        int iMid = 0;
        int nResult = 0;
        int nChars = 0;
        if (nWord[0] != 0) {
            do {
                iMid = iLow + iHigh >> 1;
                nChars = n > CSA[iMid].nWordSize ? n : CSA[iMid].nWordSize;
                for (int iCount = 0; iCount < nChars; ++iCount) {
                    if (CStr[iCount] == CSA[iMid].pt[iCount]) continue;
                    if (CStr[iCount] > CSA[iMid].pt[iCount]) {
                        nResult = 1;
                        break;
                    }
                    if (CStr[iCount] >= CSA[iMid].pt[iCount]) continue;
                    nResult = -1;
                    break;
                }
                if (nResult < 0) {
                    iHigh = iMid - 1;
                    continue;
                }
                if (nResult > 0) {
                    iLow = iMid + 1;
                    if (iLow <= iHigh) continue;
                    iMid = iLow;
                    break;
                }
                ++CSA[iMid].nCount;
                CSA[iMid].nWordsSize += CSA[iMid].nWordSize;
                return;
            } while (iHigh >= iLow);
        }
        if (nWord[0] >= Dict.MAX_WORDS) {
            return;
        }
        this.memmove(CSA, iMid + 1, CSA, iMid, nWord[0] - iMid);
        CSA[iMid].pt = CStr;
        CSA[iMid].nCount = 1;
        CSA[iMid].nWordSize = n;
        CSA[iMid].nWordsSize = n;
        CSA[nWord[0] + 1].nCount = 0;
        nWord[0] = nWord[0] + 1;
    }

    void memmove(Dict.WordItem[] Dest, int iDestStartIndex, Dict.WordItem[] Src, int iSrcStartIndex, int nCount) {
        for (int iCount = iDestStartIndex; iCount < nCount; ++iCount) {
            Dest[iCount].nCount = Src[iSrcStartIndex].nCount;
            Dest[iCount].nWordSize = Src[iSrcStartIndex].nWordSize;
            Dest[iCount].nWordsSize = Src[iSrcStartIndex].nWordsSize;
            for (int jCount = 0; jCount < Dest[iCount].pt.length; ++jCount) {
                Dest[iCount].pt[jCount] = Src[iSrcStartIndex].pt[jCount];
            }
            ++iSrcStartIndex;
        }
    }

    int DeCompress(byte[] buff, int nSize, byte[] newBuff, int[] nNewSize, Dict.CompKey KeyS, Dict.CompKey KeyD, boolean bLang) {
        int[] nCount = new int[1];
        int nChars = 0;
        int nBit = 0;
        boolean bExecuteOnce = false;
        try {
            boolean i = false;
            nBit = 0;
            while (nBit < nSize * 8) {
                byte nBitChar;
                do {
                    boolean bMyLangChar;
                    nBitChar = (byte)this.DeCompressToken(buff, nBit, newBuff, nChars, KeyS, nCount);
                    nChars += nCount[0];
                    nBit += nBitChar;
                    if (!bLang) continue;
                    if (bExecuteOnce) {
                        if (nCount[0] == 0) {
                            ++nChars;
                            nBit += 8;
                        }
                        newBuff[nChars - 1] = 59;
                        break;
                    }
                    if (nChars <= 2) continue;
                    boolean bl = bMyLangChar = newBuff[nChars - 1] >= 48 && newBuff[nChars - 1] <= 57;
                    if (!bMyLangChar) continue;
                    bExecuteOnce = true;
                } while (nChars < nNewSize[0] && newBuff[nChars - 1] != 59);
                do {
                    nBitChar = (byte)this.DeCompressToken(buff, nBit, newBuff, nChars, KeyD, nCount);
                } while ((nChars += nCount[0]) < nNewSize[0] && (nBit += nBitChar) < nSize * 8 && newBuff[nChars - 1] != 10);
                if (nBit % 8 == 0) continue;
                nBit = (nBit / 8 + 1) * 8;
            }
            nNewSize[0] = nChars;
            return 1;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    int ReadKeyFile(CustomInputStream fh, Dict.CompKey[] Key) {
        try {
            int nSize1 = 9;
            short wSize = GeneralUtils.hton(fh.readShort());
            if (this.ReadCompKey(Key, 0, fh, nSize1) == -1) {
                return -1;
            }
            byte nSize2 = Key[0].byKeysCount;
            int nSize3 = 0;
            if (Key[0].byWordsCount != 0) {
                nSize3 = Key[0].byWordsCount * 2 + Key[0].wordsOffsets[Key[0].byWordsCount] - Key[0].wordsOffsets[0];
            }
            if (this.ReadCompKeys(Key, 0, fh, Key[0].byKeysCount) == -1) {
                return -1;
            }
            if (Key[0].byWordsCount != 0) {
                if (this.ReadCompKeyWordOffset(Key, 0, fh, Key[0].byWordsCount) == -1) {
                    return -1;
                }
                if (this.ReadCompKeyWords(Key, 0, fh, wSize - nSize1 - nSize2 - Key[0].byWordsCount * 2) == -1) {
                    return -1;
                }
            }
            return wSize + 2;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    int ReadCompKeyWords(Dict.CompKey[] Key, int iKeyIndex, CustomInputStream fh, int iCount) {
        try {
            for (int i = 0; i < iCount; ++i) {
                Key[iKeyIndex].words[i] = fh.readByte();
            }
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    int ReadCompKeyWordOffset(Dict.CompKey[] Key, int iKeyIndex, CustomInputStream fh, int iCount) {
        try {
            for (int i = 0; i < iCount; ++i) {
                Key[iKeyIndex].wordsOffsets[i] = GeneralUtils.hton(fh.readShort());
            }
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    int ReadCompKeys(Dict.CompKey[] Key, int iKeyIndex, CustomInputStream fh, int iCount) {
        try {
            for (int i = 0; i < iCount; ++i) {
                Key[iKeyIndex].keys[i] = (short)(fh.readByte() & 0xFF);
            }
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    int ReadCompKey(Dict.CompKey[] Key, int iKeyIndex, CustomInputStream fh, int iCount) {
        try {
            block13: for (int i = 1; i <= iCount; ++i) {
                switch (i) {
                    case 1: {
                        Key[iKeyIndex].charCount = fh.readByte();
                        continue block13;
                    }
                    case 2: {
                        Key[iKeyIndex].nBits = fh.readByte();
                        continue block13;
                    }
                    case 3: {
                        Key[iKeyIndex].nMask = fh.readByte();
                        continue block13;
                    }
                    case 4: {
                        Key[iKeyIndex].nAMask = fh.readByte();
                        continue block13;
                    }
                    case 5: {
                        Key[iKeyIndex].nCBits = fh.readByte();
                        continue block13;
                    }
                    case 6: {
                        Key[iKeyIndex].nCMask = fh.readByte();
                        continue block13;
                    }
                    case 7: {
                        Key[iKeyIndex].nShift = fh.readByte();
                        continue block13;
                    }
                    case 8: {
                        Key[iKeyIndex].byKeysCount = fh.readByte();
                        continue block13;
                    }
                    case 9: {
                        Key[iKeyIndex].byWordsCount = fh.readByte();
                        continue block13;
                    }
                }
            }
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    boolean findWord(byte[] buff, int nIndex, int nSize, Dict.WordItem[] WordItems, byte nMax, byte[] wordID, int[] wordSize) {
        for (int i = 0; i < nMax; ++i) {
            String str1 = "";
            String str2 = "";
            char[] chrWordItem = new char[WordItems[i].pt.length];
            CCompressTxt.BytetoCharArray(chrWordItem, 0, WordItems[i].pt, 0, WordItems[i].pt.length);
            str1 = new String(chrWordItem);
            char[] chrBuff = new char[buff.length - nIndex + 1];
            CCompressTxt.BytetoCharArray(chrBuff, 0, buff, nIndex, buff.length - nIndex + 1);
            str2 = new String(chrBuff);
            int cmpSt = str1.substring(0, WordItems[i].nWordSize).compareTo(str2.substring(0, WordItems[i].nWordSize));
            if (0 != cmpSt) continue;
            wordID[0] = (byte)i;
            wordSize[0] = WordItems[i].nWordSize;
            return true;
        }
        return false;
    }

    int DeCompressToken(byte[] buff, int nBit, byte[] c, int icIndex, Dict.CompKey Key, int[] nCount) {
        try {
            short keyId;
            byte bTemp;
            byte nShift;
            int nAMask;
            byte nMask;
            byte nBits;
            short cBuff = (short)(buff[nBit / 8] & 0xFF);
            cBuff = (short)(cBuff >> nBit % 8);
            if ((cBuff & 1) != 0) {
                nBits = Key.nBits;
                nMask = Key.nMask;
                nAMask = Key.nAMask;
                nShift = Key.nShift;
            } else {
                nBits = Key.nCBits;
                nMask = Key.nCMask;
                nAMask = -1;
                nShift = 0;
            }
            if (nBit % 8 != 0) {
                if (nBits > 8 - nBit % 8) {
                    short cBuffNext = buff[nBit / 8 + 1];
                    cBuffNext = (short)(cBuffNext << 8 - nBit % 8 & 0xFF);
                    cBuff = (short)(cBuff | cBuffNext);
                }
                bTemp = (byte)(this.mirtable[(cBuff & nMask) << 8 - nBits] & 0xFF);
                keyId = (short)((bTemp & nAMask) + nShift & 0xFF);
                c[icIndex] = (byte)Key.keys[keyId];
            } else {
                bTemp = (byte)(this.mirtable[(cBuff & nMask) << 8 - nBits] & 0xFF);
                keyId = (short)((bTemp & nAMask) + nShift & 0xFF);
                c[icIndex] = (byte)Key.keys[keyId];
            }
            nCount[0] = 0;
            if (c[icIndex] == 0) {
                if (keyId != 0) {
                    int i = Key.wordsOffsets[keyId - Key.byKeysCount];
                    while (Key.words[i] != 0) {
                        int n = nCount[0];
                        nCount[0] = n + 1;
                        c[icIndex + n] = Key.words[i++];
                    }
                }
            } else {
                nCount[0] = 1;
            }
            return nBits;
        }
        catch (Exception Err) {
            return -1;
        }
    }
}

