/*
 * Decompiled with CFR 0.152.
 */
package DictPKG;

import DictPKG.ArabicDict;
import DictPKG.CAbout;
import DictPKG.CHelp;
import DictPKG.DICTDATAENTRY;
import DictPKG.DataMgr;
import DictPKG.Dictionary;
import DictPKG.ErrorHandler;
import DictPKG.I18NSupport;
import MobmeControls.IMobeEditListener;
import MobmeControls.MobmeEdit;
import MobmeControls.MobmeForm;
import MobmeControls.MobmeList;
import SplashPKG.SplashWindow;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.midlet.MIDlet;

public class EnglishDictionary
implements CommandListener {
    MobmeForm DictForm = new MobmeForm();
    Alert report;
    MobmeEdit DictEdit;
    MobmeList DictEList;
    MobmeList DictAList;
    Command CMD_About;
    Command CMD_Exit;
    Command CMD_Option;
    Command CMD_Help;
    Command CMD_BACK;
    Display SearchDisplay;
    int iEditDimension = 0;
    int iLWide = 0;
    int iLHeight = 0;
    int iEListNum = 0;
    int iAListNum = 0;
    String[] strEData;
    String[] strAData;
    int iCurrEIndex = 0;
    int iCurrAIndex = 0;
    int[] iWordIDs;
    GetNextPre GetNextPreHdl = new GetNextPre();
    Dictionary m_ParentMidlet;
    DataMgr DataMgrObj = new DataMgr(true);
    DICTDATAENTRY[] pEntry;
    DataMgr.CENUMGLOSSARIESPROC Proc;
    ApllySearch MySearchObj = new ApllySearch();
    DrawInterface m_InterfaceObj = new DrawInterface();
    SplashWindow m_SplashWin = null;

    public void DisplayAlert(String strMSG) {
        this.report = new Alert(I18NSupport.getMessage("Sorry"), null, null, null);
        this.report.setTimeout(-2);
        this.report.setType(AlertType.ERROR);
        this.report.setString(strMSG);
        this.SearchDisplay.setCurrent((Displayable)this.report);
    }

    public EnglishDictionary(Display ParentDisplay, MIDlet ParentMidlet) {
        try {
            this.Proc = null;
            this.SearchDisplay = ParentDisplay;
            this.m_ParentMidlet = (Dictionary)ParentMidlet;
            if (Dictionary.FirstTime) {
                this.m_SplashWin = new SplashWindow((Displayable)this.DictForm, Font.getDefaultFont(), "/Res/Splash240x320.png", true);
                Dictionary.FirstTime = false;
            } else {
                this.m_SplashWin = new SplashWindow((Displayable)this.DictForm, Font.getDefaultFont(), "/Res/Loading.png", false);
            }
            this.m_SplashWin.Show(this.SearchDisplay);
            new Thread(this.m_InterfaceObj).start();
            new Thread(this.MySearchObj).start();
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
    }

    void InitScreen() {
    }

    void SetDimension() {
        int iShare = (this.DictForm.getHeight() - this.DictEdit.getPreferredHeight() - this.DictForm.m_iPad * 3) / 2;
        this.iLWide = this.DictForm.getWidth();
        this.iLHeight = iShare;
    }

    public boolean DrawMyScreen() {
        try {
            Font MyEFont = Font.getDefaultFont();
            this.InitForm();
            this.SetDimension();
            this.iEListNum = this.GetListContentNum(MyEFont, this.iLHeight);
            this.strEData = new String[this.iEListNum];
            if (!this.InitDict()) {
                return false;
            }
            this.InitList(true);
            this.DictEList = new MobmeList(I18NSupport.getMessage("Hello"), (Displayable)this.DictForm, this.SearchDisplay, MyEFont, false, this.strEData, this.iEListNum);
            this.DictEList.SetBGColor(0xFFFFFF);
            this.DictEList.SetHLColor(49151);
            this.DictEList.SetDimension(this.iLWide, this.iLHeight);
            this.iAListNum = this.GetListContentNum(MyEFont, this.iLHeight);
            this.strAData = new String[this.iAListNum];
            this.InitList(false);
            this.DictAList = new MobmeList(I18NSupport.getMessage("Hello"), (Displayable)this.DictForm, this.SearchDisplay, MyEFont, true, this.strAData, this.pEntry[0].nMeaningsCount);
            this.DictAList.SetBGColor(49151);
            this.DictAList.SetDrawBullets(true);
            this.DictAList.SetDimension(this.iLWide, this.iLHeight);
            this.DictAList.SetFocusItem(-1);
            this.DictForm.append(this.DictEList);
            this.DictForm.append(this.DictAList);
            this.DictEdit.SetString(this.pEntry[0].szWord);
            this.DictEList.UpdateList(this.strEData, 0, this.iEListNum);
            this.DictAList.UpdateList(this.strAData, 0, this.pEntry[0].nMeaningsCount);
            if (this.pEntry[0].nMeaningsCount > this.iAListNum) {
                this.DictAList.UpdateList(this.strAData, 0, this.iAListNum);
            } else {
                this.DictAList.UpdateList(this.strAData, 0, this.pEntry[0].nMeaningsCount);
            }
            return true;
        }
        catch (Exception Err) {
            this.DisplayAlert("Error Displaying Form");
            this.DictForm.RefreshScreen();
            return false;
        }
    }

    void InitForm() {
        Font MyEFont = Font.getDefaultFont();
        this.iEditDimension = MyEFont.getHeight() + 4;
        String[] arrHistory = new String[10];
        this.DictEdit = new MobmeEdit(I18NSupport.getMessage("Hello"), (Displayable)this.DictForm, this.SearchDisplay, MyEFont, false);
        this.DictEdit.SetListenerForDirection(this.GetNextPreHdl);
        this.DictForm.setTitle(I18NSupport.getMessage("Dic"));
        this.DictForm.append(this.DictEdit);
        this.AddControls((Displayable)this.DictForm);
    }

    void InitList(boolean bLang) {
        if (bLang) {
            for (int i = 0; i < this.strEData.length; ++i) {
                this.DataMgrObj.GetAt(i, this.pEntry, i, true);
                this.strEData[i] = this.pEntry[i].szWord;
                this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
            }
        } else {
            if (this.strAData.length < this.pEntry[0].nMeaningsCount) {
                this.strAData = new String[this.pEntry[0].nMeaningsCount];
            }
            for (int i = 0; i < this.pEntry[0].nMeaningsCount; ++i) {
                this.strAData[i] = this.pEntry[0].szMeanings[i];
            }
        }
    }

    int GetListContentNum(Font MyFont, int iHeight) {
        int iItemHeight = MyFont.getHeight() + 3;
        return iHeight / iItemHeight;
    }

    void AddControls(Displayable s) {
        this.CMD_Exit = new Command(I18NSupport.getMessage("Exit"), 7, 1);
        this.CMD_About = new Command(I18NSupport.getMessage("About"), 1, 2);
        this.CMD_Option = new Command(I18NSupport.getMessage("Arabic"), 7, 3);
        this.CMD_Help = new Command(I18NSupport.getMessage("Help"), 1, 0);
        this.DictForm.addCommand(this.CMD_Exit);
        this.DictForm.addCommand(this.CMD_Option);
        this.DictForm.addCommand(this.CMD_Help);
        this.DictForm.addCommand(this.CMD_About);
        this.DictForm.setCommandListener(this);
    }

    boolean InitDict() {
        try {
            this.pEntry = new DICTDATAENTRY[this.iEListNum];
            this.iWordIDs = new int[this.iEListNum];
            Object nullObj = new Object();
            nullObj = null;
            this.DataMgrObj.EnumGlossaries("/res", this.Proc, nullObj);
            if (!this.DataMgrObj.Init(0)) {
                new ErrorHandler(this.m_ParentMidlet, "Error Loading Dictionary, Files might be missing or corrupt");
                return false;
            }
            this.DataMgrObj.GetAt(0, this.pEntry, 0, true);
            if (this.pEntry == null || this.pEntry[0] == null) {
                this.DisplayAlert("Error Intializing Dictionary - GetData");
                return false;
            }
            return true;
        }
        catch (Exception Err) {
            Err.printStackTrace();
            this.DisplayAlert("Error Intializing Dictionary");
            return false;
        }
    }

    public void doExit() {
        this.m_ParentMidlet.DestroyApp(true);
        this.m_ParentMidlet.notifyDestroyed();
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    void SearchPartialWord(String strData) {
        DICTDATAENTRY[] pTemp = new DICTDATAENTRY[1];
        this.DataMgrObj.GetAt(strData, pTemp, 0);
        if (pTemp[0] != null) {
            int iIndex = this.DataMgrObj.GetCurSel(null);
            if (iIndex > -1 && iIndex < this.DataMgrObj.GetWordsCount()) {
                this.strEData = new String[this.iEListNum];
                int iLimit = this.DataMgrObj.GetWordsCount() - iIndex;
                int iWordIndex = iIndex;
                for (int i = 0; i < this.iEListNum && iLimit > 0; ++i) {
                    if (i == iLimit) {
                        iWordIndex = 0;
                    }
                    this.DataMgrObj.GetAt(iWordIndex, this.pEntry, i, true);
                    this.strEData[i] = this.pEntry[i].szWord;
                    this.iWordIDs[i] = iWordIndex++;
                }
            }
            this.strAData = new String[this.pEntry[0].nMeaningsCount];
            for (int i = 0; i < this.pEntry[0].nMeaningsCount; ++i) {
                this.strAData[i] = this.pEntry[0].szMeanings[i];
            }
            this.iCurrEIndex = 0;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.CMD_BACK) {
            this.SearchDisplay.setCurrent((Displayable)this.DictForm);
        }
        if (c == this.CMD_Exit) {
            this.doExit();
            return;
        }
        if (c == this.CMD_Help) {
            try {
                this.SearchDisplay.setCurrent((Displayable)new CHelp(this.SearchDisplay, (Displayable)this.DictForm));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (c == this.CMD_About) {
            CAbout AboutObj = new CAbout(this.SearchDisplay, (Displayable)this.DictForm, false);
            this.DictEdit.m_bIsTraversedOut = true;
        }
        if (c == this.CMD_Option) {
            while (this.MySearchObj.m_IamISearch) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.DataMgrObj.m_pCurGlossary[0].CloseDatFile();
            this.Destry();
            System.gc();
            I18NSupport.initLocalizationSupport("ar-EG");
            this.m_ParentMidlet.Arabic_Dict[0] = new ArabicDict(this.SearchDisplay, this.m_ParentMidlet);
        }
    }

    void FillEnglishList(String[] strList, int iBaseIndex, int iNum, boolean bisNext) {
        if (bisNext) {
            if (iBaseIndex == this.DataMgrObj.GetWordsCount() - 1) {
                this.GetReverseList(false);
                return;
            }
            int iFirstItem = 0;
            int iCount = 0;
            iFirstItem = iBaseIndex - (iNum - 1) + 1;
            this.DataMgrObj.GetAt(iFirstItem, this.pEntry, 0, true);
            if (this.pEntry[0] == null) {
                return;
            }
            strList[0] = this.pEntry[0].szWord;
            this.iWordIDs[0] = this.DataMgrObj.GetCurSel(null);
            ++iFirstItem;
            for (int i = 1; i < iNum; ++i) {
                if (iFirstItem > this.DataMgrObj.GetWordsCount()) {
                    this.DataMgrObj.GetAt(iCount, this.pEntry, iCount, true);
                    if (this.pEntry[iCount] != null) {
                        strList[i] = this.pEntry[iCount].szWord;
                        this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
                        ++iCount;
                        continue;
                    }
                    return;
                }
                this.DataMgrObj.GetNext(this.pEntry, i);
                if (this.pEntry[i] != null) {
                    strList[i] = this.pEntry[i].szWord;
                    this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
                    continue;
                }
                return;
            }
        } else {
            if (iBaseIndex == 0) {
                this.GetReverseList(true);
                return;
            }
            int iLastItem = 0;
            int iCount = this.DataMgrObj.GetWordsCount() - 1;
            iLastItem = iBaseIndex + iNum - 2;
            this.DataMgrObj.GetAt(iLastItem, this.pEntry, iNum - 1, true);
            if (this.pEntry[iNum - 1] == null) {
                return;
            }
            strList[iNum - 1] = this.pEntry[iNum - 1].szWord;
            this.iWordIDs[iNum - 1] = this.DataMgrObj.GetCurSel(null);
            iCount = --iLastItem;
            for (int i = iNum - 2; i >= 0; --i) {
                if (iLastItem < 0) {
                    this.DataMgrObj.GetAt(iCount, this.pEntry, iCount, true);
                    if (this.pEntry[iCount] != null) {
                        strList[i] = this.pEntry[iCount].szWord;
                        this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
                        --iCount;
                        continue;
                    }
                    return;
                }
                this.DataMgrObj.GetPre(this.pEntry, i);
                if (this.pEntry[i] != null) {
                    strList[i] = this.pEntry[i].szWord;
                    this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
                    continue;
                }
                return;
            }
        }
    }

    void GetReverseList(boolean isUp) {
        if (isUp) {
            int iCount = this.DataMgrObj.GetWordsCount();
            if (iCount > 0) {
                int i;
                int iRevIndex = iCount - this.iEListNum;
                this.strEData = new String[this.iEListNum];
                for (i = 0; i < this.iEListNum; ++i) {
                    this.DataMgrObj.GetAt(iRevIndex, this.pEntry, i, true);
                    this.strEData[i] = this.pEntry[i].szWord;
                    this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
                    ++iRevIndex;
                }
                this.strAData = new String[this.pEntry[this.iEListNum - 1].nMeaningsCount];
                for (i = 0; i < this.pEntry[this.iEListNum - 1].nMeaningsCount; ++i) {
                    this.strAData[i] = this.pEntry[this.iEListNum - 1].szMeanings[i];
                }
                this.iCurrEIndex = this.iEListNum - 1;
            }
        } else {
            int i;
            boolean iCount = false;
            this.strEData = new String[this.iEListNum];
            for (i = 0; i < this.iEListNum; ++i) {
                this.DataMgrObj.GetAt(i, this.pEntry, i, true);
                this.strEData[i] = this.pEntry[i].szWord;
                this.iWordIDs[i] = this.DataMgrObj.GetCurSel(null);
            }
            this.strAData = new String[this.pEntry[0].nMeaningsCount];
            for (i = 0; i < this.pEntry[0].nMeaningsCount; ++i) {
                this.strAData[i] = this.pEntry[0].szMeanings[i];
            }
            this.iCurrEIndex = 0;
        }
    }

    void ScrollArabicList(DICTDATAENTRY[] SourceOfData, int iSrcIndex, String[] strDestData, int iDesIndex, int iDestLen, boolean bDirection) {
        try {
            if (bDirection) {
                for (int i = 0; i < iDestLen; ++i) {
                    strDestData[i] = i == iDestLen - 1 ? SourceOfData[iSrcIndex].szMeanings[iDesIndex] : strDestData[i + 1];
                }
            } else {
                if (iDesIndex == 0) {
                    return;
                }
                for (int i = iDestLen - 1; i >= 0; --i) {
                    strDestData[i] = i == 0 ? SourceOfData[iSrcIndex].szMeanings[iDesIndex] : strDestData[i - 1];
                }
            }
        }
        catch (Exception Err) {
            this.DisplayAlert("Error Retrieving Data");
            this.DictForm.RefreshScreen();
        }
    }

    void Destry() {
        this.DictForm = null;
        this.report = null;
        this.DictEdit = null;
        this.DictEList = null;
        this.DictAList = null;
        this.CMD_About = null;
        this.CMD_Exit = null;
        this.CMD_Option = null;
        this.strEData = null;
        this.strAData = null;
        this.iWordIDs = null;
        this.GetNextPreHdl = null;
        this.DataMgrObj = null;
        this.pEntry = null;
        this.Proc = null;
        this.MySearchObj = null;
    }

    class ApllySearch
    implements Runnable {
        String m_strSearchData = "";
        boolean m_bCancelPreviousSearch = false;
        boolean m_IamISearch = false;

        ApllySearch() {
        }

        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(150L);
                            if (this.m_strSearchData.length() == 0) continue;
                            this.DoSearch(this.m_strSearchData);
                            this.m_IamISearch = false;
                            this.m_bCancelPreviousSearch = false;
                        }
                    }
                    catch (Exception Err) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        void SetSearchData(String strData) {
            this.m_strSearchData = strData;
        }

        void DoSearch(String strData) {
            this.m_IamISearch = true;
            while (!this._SearchPartialWord(strData)) {
                if (this.m_bCancelPreviousSearch) {
                    return;
                }
                if (strData.length() <= 1) break;
                strData = strData.substring(0, strData.length() - 1);
            }
            if (this.m_bCancelPreviousSearch) {
                return;
            }
            EnglishDictionary.this.DictEList.UpdateList(EnglishDictionary.this.strEData, 0, EnglishDictionary.this.iEListNum);
            if (EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount > EnglishDictionary.this.iAListNum) {
                EnglishDictionary.this.DictAList.SetScrollSymbol(true);
                EnglishDictionary.this.iCurrAIndex = 0;
                EnglishDictionary.this.DictAList.UpdateList(EnglishDictionary.this.strAData, 0, EnglishDictionary.this.iAListNum);
            } else {
                EnglishDictionary.this.DictAList.ResetScrollSymbol();
                EnglishDictionary.this.DictAList.UpdateList(EnglishDictionary.this.strAData, 0, EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount);
            }
            EnglishDictionary.this.DictEList.SetFocusItem(EnglishDictionary.this.iCurrEIndex);
            if (!this.m_bCancelPreviousSearch) {
                this.SetSearchData("");
            }
        }

        boolean _SearchPartialWord(String strData) {
            try {
                DICTDATAENTRY[] pTemp = new DICTDATAENTRY[1];
                int iPos = 0;
                if (this.m_bCancelPreviousSearch) {
                    return true;
                }
                EnglishDictionary.this.DataMgrObj.GetAt(strData, pTemp, 0);
                if (this.m_bCancelPreviousSearch) {
                    return true;
                }
                if (pTemp[0] != null) {
                    int iIndex = EnglishDictionary.this.DataMgrObj.GetCurSel(null);
                    if (iIndex == EnglishDictionary.this.iWordIDs[EnglishDictionary.this.iCurrEIndex]) {
                        return true;
                    }
                    int iDictCount = EnglishDictionary.this.DataMgrObj.GetWordsCount();
                    if (iIndex > -1 && iIndex < iDictCount) {
                        EnglishDictionary.this.strEData = new String[EnglishDictionary.this.iEListNum];
                        if (iDictCount - iIndex < EnglishDictionary.this.iEListNum) {
                            iPos = EnglishDictionary.this.iEListNum - (iDictCount - iIndex);
                        }
                        int iWordIndex = iIndex - iPos;
                        for (int i = 0; i < EnglishDictionary.this.strEData.length; ++i) {
                            EnglishDictionary.this.DataMgrObj.GetAt(iWordIndex, EnglishDictionary.this.pEntry, i, true);
                            EnglishDictionary.this.strEData[i] = EnglishDictionary.this.pEntry[i].szWord;
                            EnglishDictionary.this.iWordIDs[i] = iWordIndex++;
                        }
                    }
                    EnglishDictionary.this.strAData = new String[EnglishDictionary.this.pEntry[iPos].nMeaningsCount];
                    for (int i = 0; i < EnglishDictionary.this.pEntry[iPos].nMeaningsCount; ++i) {
                        EnglishDictionary.this.strAData[i] = EnglishDictionary.this.pEntry[iPos].szMeanings[i];
                    }
                    EnglishDictionary.this.iCurrEIndex = iPos;
                    if (!this.m_bCancelPreviousSearch) {
                        this.SetSearchData("");
                    }
                    return true;
                }
                return false;
            }
            catch (Exception Err) {
                EnglishDictionary.this.DisplayAlert("Error In Search 1");
                EnglishDictionary.this.DictForm.RefreshScreen();
                return false;
            }
        }
    }

    public class GetNextPre
    implements IMobeEditListener {
        String[] strArrayCpy;
        boolean bIsHasCopy = false;

        public void OnPressNext() {
            try {
                if (EnglishDictionary.this.MySearchObj.m_IamISearch) {
                    EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch = true;
                    EnglishDictionary.this.MySearchObj.SetSearchData("");
                    while (EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch || EnglishDictionary.this.MySearchObj.m_strSearchData.length() > 0) {
                        Thread.sleep(150L);
                    }
                }
                EnglishDictionary.this.MySearchObj.SetSearchData("");
                if (EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount > EnglishDictionary.this.iAListNum && EnglishDictionary.this.iCurrAIndex + EnglishDictionary.this.iAListNum < EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount) {
                    ++EnglishDictionary.this.iCurrAIndex;
                    EnglishDictionary.this.DictAList.ScrollList(6);
                    return;
                }
                EnglishDictionary.this.DictAList.ResetScrollSymbol();
                EnglishDictionary.this.iCurrAIndex = 0;
                ++EnglishDictionary.this.iCurrEIndex;
                if (EnglishDictionary.this.iCurrEIndex == EnglishDictionary.this.iEListNum) {
                    EnglishDictionary.this.iCurrEIndex = EnglishDictionary.this.iEListNum - 1;
                    EnglishDictionary.this.strEData = new String[EnglishDictionary.this.iEListNum];
                    EnglishDictionary.this.FillEnglishList(EnglishDictionary.this.strEData, EnglishDictionary.this.iWordIDs[EnglishDictionary.this.iCurrEIndex], EnglishDictionary.this.iEListNum, true);
                    EnglishDictionary.this.DictEList.UpdateList(EnglishDictionary.this.strEData, 0, EnglishDictionary.this.iEListNum);
                } else {
                    EnglishDictionary.this.DictEList.SetFocusItem(EnglishDictionary.this.iCurrEIndex);
                }
                EnglishDictionary.this.strAData = new String[EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount];
                for (int i = 0; i < EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount; ++i) {
                    EnglishDictionary.this.strAData[i] = EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].szMeanings[i];
                }
                if (EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount > EnglishDictionary.this.iAListNum) {
                    EnglishDictionary.this.DictAList.UpdateList(EnglishDictionary.this.strAData, 0, EnglishDictionary.this.iAListNum);
                } else {
                    EnglishDictionary.this.DictAList.UpdateList(EnglishDictionary.this.strAData, 0, EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount);
                }
                EnglishDictionary.this.DictEdit.SetString(EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].szWord);
                EnglishDictionary.this.DictEList.SetFocusItem(EnglishDictionary.this.iCurrEIndex);
            }
            catch (Exception Err) {
                EnglishDictionary.this.DisplayAlert("Error Retrieving Next Entry  : " + Err.getMessage());
                EnglishDictionary.this.DictForm.RefreshScreen();
            }
        }

        public void OnPressPrevious() {
            try {
                if (EnglishDictionary.this.MySearchObj.m_IamISearch) {
                    EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch = true;
                    EnglishDictionary.this.MySearchObj.SetSearchData("");
                    while (EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch || EnglishDictionary.this.MySearchObj.m_strSearchData.length() > 0) {
                        Thread.sleep(150L);
                    }
                }
                EnglishDictionary.this.MySearchObj.SetSearchData("");
                if (EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount > EnglishDictionary.this.iAListNum && EnglishDictionary.this.iCurrAIndex > 0) {
                    --EnglishDictionary.this.iCurrAIndex;
                    EnglishDictionary.this.DictAList.ScrollList(1);
                    return;
                }
                EnglishDictionary.this.DictAList.ResetScrollSymbol();
                EnglishDictionary.this.iCurrAIndex = 0;
                --EnglishDictionary.this.iCurrEIndex;
                if (EnglishDictionary.this.iCurrEIndex < 0) {
                    EnglishDictionary.this.iCurrEIndex = 0;
                    EnglishDictionary.this.strEData = new String[EnglishDictionary.this.iEListNum];
                    EnglishDictionary.this.FillEnglishList(EnglishDictionary.this.strEData, EnglishDictionary.this.iWordIDs[EnglishDictionary.this.iCurrEIndex], EnglishDictionary.this.iEListNum, false);
                    EnglishDictionary.this.DictEList.UpdateList(EnglishDictionary.this.strEData, 0, EnglishDictionary.this.iEListNum);
                } else {
                    EnglishDictionary.this.DictEList.SetFocusItem(EnglishDictionary.this.iCurrEIndex);
                }
                EnglishDictionary.this.strAData = new String[EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount];
                for (int i = 0; i < EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount; ++i) {
                    EnglishDictionary.this.strAData[i] = EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].szMeanings[i];
                }
                if (EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount > EnglishDictionary.this.iAListNum) {
                    EnglishDictionary.this.DictAList.UpdateList(EnglishDictionary.this.strAData, 0, EnglishDictionary.this.iAListNum);
                } else {
                    EnglishDictionary.this.DictAList.UpdateList(EnglishDictionary.this.strAData, 0, EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].nMeaningsCount);
                }
                EnglishDictionary.this.DictEdit.SetString(EnglishDictionary.this.pEntry[EnglishDictionary.this.iCurrEIndex].szWord);
                EnglishDictionary.this.DictEList.SetFocusItem(EnglishDictionary.this.iCurrEIndex);
            }
            catch (Exception Err) {
                EnglishDictionary.this.DisplayAlert("Error Retrieving Previous Entry");
                EnglishDictionary.this.DictForm.RefreshScreen();
            }
        }

        public void OnEditChange(String strData) {
            try {
                if (strData.length() == 0) {
                    return;
                }
                if (EnglishDictionary.this.MySearchObj.m_IamISearch) {
                    EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch = true;
                }
                EnglishDictionary.this.MySearchObj.m_strSearchData = strData;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void OnPressRight() {
            try {
                if (EnglishDictionary.this.MySearchObj.m_IamISearch) {
                    EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch = true;
                    Thread.sleep(150L);
                }
                EnglishDictionary.this.MySearchObj.SetSearchData("");
                EnglishDictionary.this.DictAList.DoHScrollRight();
            }
            catch (Exception Ex) {
                EnglishDictionary.this.DisplayAlert("Error Scrolling Right");
                EnglishDictionary.this.DictForm.RefreshScreen();
            }
        }

        public void OnPressLeft() {
            try {
                if (EnglishDictionary.this.MySearchObj.m_IamISearch) {
                    EnglishDictionary.this.MySearchObj.m_bCancelPreviousSearch = true;
                    Thread.sleep(150L);
                }
                EnglishDictionary.this.MySearchObj.SetSearchData("");
                EnglishDictionary.this.DictAList.DoHScrollLeft();
            }
            catch (Exception Ex) {
                EnglishDictionary.this.DisplayAlert("Error Scrolling Left");
                EnglishDictionary.this.DictForm.RefreshScreen();
            }
        }
    }

    class DrawInterface
    implements Runnable {
        boolean b_InitFinished = false;

        DrawInterface() {
        }

        public void run() {
            try {
                if (!EnglishDictionary.this.DrawMyScreen()) {
                    this.b_InitFinished = true;
                    return;
                }
                this.b_InitFinished = true;
                while (!SplashWindow.m_SplashTimedOut) {
                    Thread.sleep(50L);
                }
                EnglishDictionary.this.SearchDisplay.setCurrent((Displayable)EnglishDictionary.this.DictForm);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

