/*
 * Decompiled with CFR 0.152.
 */
package DictPKG;

import DictPKG.CCompressTxt;
import DictPKG.DICTDATAENTRY;
import DictPKG.DICTDATAFILEHEADER;
import DictPKG.DICTDATAFILEHEADER1;
import DictPKG.DICTDATAFILEHEADEROLD;
import DictPKG.DICTINDEXFILEHEADER;
import DictPKG.Dict;
import DictPKG.HelpFunctions;
import GeneralLibs.CustomInputStream;
import GeneralLibs.GeneralUtils;
import GeneralLibs.PartFileInputStream;
import java.io.IOException;

public class Glossary
extends HelpFunctions {
    private boolean m_bInitialized = false;
    private CustomInputStream m_hDataFile = null;
    private DICTDATAFILEHEADER1 m_dfh1 = new DICTDATAFILEHEADER1();
    private DICTDATAFILEHEADER m_dfh = new DICTDATAFILEHEADER();
    private DICTINDEXFILEHEADER m_ifh = new DICTINDEXFILEHEADER();
    private CCompressTxt ct = null;
    private Dict.CompKey[] m_KeyDes;
    private Dict.CompKey[] m_KeySrc;
    private int m_nKeysSize = 0;
    private int[] m_pCharsPointers = null;
    int[] m_lpdwIndex = null;
    private boolean m_bLang = true;

    private void Clear() {
        try {
            if (this.m_lpdwIndex != null) {
                this.m_lpdwIndex = null;
            }
            if (this.m_hDataFile != null) {
                this.m_hDataFile.close();
            }
            this.m_hDataFile = null;
            if (this.ct != null) {
                this.ct = null;
            }
            this.m_nKeysSize = 0;
            this.m_lpdwIndex = null;
            this.m_bInitialized = false;
            if (this.m_pCharsPointers != null) {
                this.m_pCharsPointers = null;
            }
            this.m_dfh = new DICTDATAFILEHEADER();
            this.m_ifh = new DICTINDEXFILEHEADER();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int GetNumberOfWords() {
        if (this.m_bInitialized) {
            return this.m_ifh.dwNumEntries;
        }
        return 0;
    }

    public int GetMeaningsLanguageID() {
        if (this.m_bInitialized) {
            return this.m_dfh.lidMeaning;
        }
        return 0;
    }

    public int GetWordLanguageID() {
        if (this.m_bInitialized) {
            return this.m_dfh.lidWord;
        }
        return 0;
    }

    public int GetHumanReadableName(String szGlossaryName) {
        if (this.m_bInitialized && szGlossaryName != "") {
            szGlossaryName = new String(this.m_dfh.GlossaryName);
        }
        return 0;
    }

    public boolean SetFileNames(String szDictDataFile, String szDictindexFile) {
        PartFileInputStream hDatFile = null;
        PartFileInputStream hIndexFile = null;
        try {
            boolean bRet = false;
            short wSize = DICTDATAFILEHEADER.DICTDATAFILEHEADER_SIZE;
            hDatFile = new PartFileInputStream(szDictDataFile);
            hIndexFile = new PartFileInputStream(szDictindexFile);
            this.m_dfh1.wSize = GeneralUtils.hton(hDatFile.readShort());
            if (this.m_dfh1.wSize != 17476) {
                if (this.m_dfh1.wSize < wSize) {
                    wSize = this.m_dfh1.wSize;
                }
                if (this.FileRead_DICTDATAFILEHEADER_NewFormat(hDatFile, szDictDataFile, wSize) == -1) {
                    if (hDatFile != null) {
                        hDatFile.close();
                    }
                    if (hIndexFile != null) {
                        hIndexFile.close();
                    }
                    return false;
                }
                String str = new String(this.m_dfh.GlossaryName);
                short nSeekPoint = (short)(this.m_dfh1.wSize + 2);
                hDatFile.setPosition(nSeekPoint);
            } else {
                hDatFile.reset();
                if (this.FileRead_DICTDATAFILEHEADER_OldFormat(hDatFile, szDictDataFile) == -1) {
                    if (hDatFile != null) {
                        hDatFile.close();
                    }
                    if (hIndexFile != null) {
                        hIndexFile.close();
                    }
                    return false;
                }
            }
            if (this.ReadIndexFile(hIndexFile, szDictindexFile) == -1) {
                if (hDatFile != null) {
                    hDatFile.close();
                }
                if (hIndexFile != null) {
                    hIndexFile.close();
                }
                return false;
            }
            short Temp = GeneralUtils.hton(hIndexFile.readShort());
            this.m_pCharsPointers = new int[this.m_ifh.nCharsSize];
            for (int iCount = 0; iCount < this.m_ifh.nCharsSize; ++iCount) {
                this.m_pCharsPointers[iCount] = GeneralUtils.htonl(hIndexFile.readShort() & 0xFFFF);
            }
            if (this.m_dfh.wVersion >= 11) {
                this.ct = new CCompressTxt();
                this.m_KeySrc = new Dict.CompKey[1];
                this.m_KeySrc[0] = new Dict.CompKey();
                this.m_KeyDes = new Dict.CompKey[1];
                this.m_KeyDes[0] = new Dict.CompKey();
                this.m_nKeysSize = this.ct.ReadKeyFile(hDatFile, this.m_KeySrc);
                this.m_nKeysSize += this.ct.ReadKeyFile(hDatFile, this.m_KeyDes);
            }
            if (this.m_ifh.dwNumEntries == 0) {
                if (hDatFile != null) {
                    hDatFile.close();
                }
                if (hIndexFile != null) {
                    hIndexFile.close();
                }
                return false;
            }
            this.m_lpdwIndex = new int[this.m_ifh.dwNumEntries];
            if (this.m_lpdwIndex == null) {
                if (hDatFile != null) {
                    hDatFile.close();
                }
                if (hIndexFile != null) {
                    hIndexFile.close();
                }
                return false;
            }
            hIndexFile.setPosition(DICTINDEXFILEHEADER.DICTINDEXFILEHEADER_SIZE + this.m_ifh.nCharsSize * 2);
            if (Glossary.ReadIntArray(hIndexFile, this.m_lpdwIndex, this.m_ifh.dwNumEntries) == -1) {
                if (hDatFile != null) {
                    hDatFile.close();
                }
                if (hIndexFile != null) {
                    hIndexFile.close();
                }
                return false;
            }
            this.m_hDataFile = hDatFile;
            this.m_bInitialized = true;
            if (hIndexFile != null) {
                hIndexFile.close();
            }
            return true;
        }
        catch (IOException ioErr) {
            return false;
        }
        catch (Exception Err) {
            return false;
        }
    }

    int FileRead_DICTDATAFILEHEADER_NewFormat(CustomInputStream hDatFile, String szDictDataFile, short nSize) {
        try {
            this.m_dfh.wSignature = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.wVersion = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.wWordCodePage = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.wMeaningCodePage = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.lidWord = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.lidMeaning = GeneralUtils.hton(hDatFile.readShort());
            int iCounter = 12;
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryName);
                iCounter += 16;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextNoun);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextVerb);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextAdjective);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextAdverb);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextArticle);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextAuxiliary);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextConjunction);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextInterjection);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextPreposition);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextPronoun);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextPhrasalVerb);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextIdiomNoun);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextIdiomAdj);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextIdiomAdverb);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextPluralNoun);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextNounPlural);
                iCounter += 20;
            }
            if (iCounter < nSize) {
                Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryTextComputer);
                iCounter += 20;
            }
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    int FileRead_DICTDATAFILEHEADER_OldFormat(CustomInputStream hDatFile, String szDictDataFile) {
        try {
            this.m_dfh.wSignature = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.wVersion = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.wWordCodePage = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.wMeaningCodePage = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.lidWord = GeneralUtils.hton(hDatFile.readShort());
            this.m_dfh.lidMeaning = GeneralUtils.hton(hDatFile.readShort());
            Glossary.ReadCharArray(hDatFile, this.m_dfh.GlossaryName);
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    public boolean GetWordData(int iIndex, DICTDATAENTRY[] ppEntry, int ipEntryIndex) {
        try {
            int nSize = 0;
            int nOffset = 0;
            DICTDATAFILEHEADEROLD OldHdr = new DICTDATAFILEHEADEROLD();
            if (iIndex >= 0 && iIndex < this.m_ifh.dwNumEntries) {
                if (this.m_dfh1.wSize != 17476) {
                    if (this.m_dfh.wVersion >= 11) {
                        int n = iIndex != 0 ? this.m_lpdwIndex[iIndex - 1] : (nOffset = DICTDATAFILEHEADER.DICTDATAFILEHEADER_SIZE + 2 + this.m_nKeysSize);
                        nSize = iIndex != 0 ? this.m_lpdwIndex[iIndex] - this.m_lpdwIndex[iIndex - 1] : this.m_lpdwIndex[iIndex] - (DICTDATAFILEHEADER.DICTDATAFILEHEADER_SIZE + 2 + this.m_nKeysSize);
                    } else {
                        int n = iIndex != 0 ? this.m_lpdwIndex[iIndex - 1] : (nOffset = DICTDATAFILEHEADER.DICTDATAFILEHEADER_SIZE + 2);
                        nSize = iIndex != 0 ? this.m_lpdwIndex[iIndex] - this.m_lpdwIndex[iIndex - 1] : this.m_lpdwIndex[iIndex] - (DICTDATAFILEHEADER.DICTDATAFILEHEADER_SIZE + 2);
                    }
                } else if (this.m_dfh.wVersion >= 11) {
                    int n = iIndex != 0 ? this.m_lpdwIndex[iIndex - 1] : (nOffset = DICTDATAFILEHEADEROLD.DICTDATAFILEHEADEROLD_SIZE + this.m_nKeysSize);
                    nSize = iIndex != 0 ? this.m_lpdwIndex[iIndex] - this.m_lpdwIndex[iIndex - 1] : this.m_lpdwIndex[iIndex] - (DICTDATAFILEHEADEROLD.DICTDATAFILEHEADEROLD_SIZE + this.m_nKeysSize);
                } else {
                    int n = iIndex != 0 ? this.m_lpdwIndex[iIndex - 1] : (nOffset = DICTDATAFILEHEADEROLD.DICTDATAFILEHEADEROLD_SIZE);
                    int n2 = iIndex != 0 ? this.m_lpdwIndex[iIndex] - this.m_lpdwIndex[iIndex - 1] : (nSize = this.m_lpdwIndex[iIndex] - DICTDATAFILEHEADEROLD.DICTDATAFILEHEADEROLD_SIZE);
                }
            }
            if (nSize != 0) {
                String strWord;
                int nToken;
                byte[] szEntry = new byte[nSize + 1];
                this.m_hDataFile.setPosition(nOffset);
                this.m_hDataFile.read(szEntry, nSize);
                szEntry[nSize] = 0;
                int i = 0;
                DICTDATAENTRY pEntry = new DICTDATAENTRY();
                if (this.m_dfh.wVersion >= 11) {
                    int[] nNewSize = new int[]{nSize * 3};
                    byte[] szEntryPlain = new byte[nNewSize[0] + 1];
                    this.ct.DeCompress(szEntry, nSize, szEntryPlain, nNewSize, this.m_KeySrc[0], this.m_KeyDes[0], this.m_bLang);
                    szEntryPlain[nNewSize[0]] = 0;
                    if (nNewSize[0] >= nSize * 3) {
                        return false;
                    }
                    szEntry = szEntryPlain;
                }
                int nMeaningsCount = 0;
                int ii = 0;
                char[] chrTemp = new char[szEntry.length];
                while (szEntry[ii] != 0) {
                    if (szEntry[ii] == 59) {
                        ++nMeaningsCount;
                    }
                    chrTemp[ii] = (char)(szEntry[ii] & 0xFF);
                    ++ii;
                }
                pEntry.nMeaningsCount = nMeaningsCount;
                String szToken = String.valueOf(chrTemp, 0, ii);
                int iGotToken = szToken.indexOf(";");
                if (iGotToken != -1) {
                    nToken = szToken.length();
                    pEntry.szWordCode = new char[iGotToken];
                    char[] chrToken = new char[iGotToken];
                    szToken.getChars(0, iGotToken, chrToken, 0);
                    Glossary.InternalMultiByteToWideChar(this.m_dfh.wWordCodePage, 0, chrToken, iGotToken, pEntry.szWordCode, iGotToken);
                }
                String WordCodeCpy = new String(pEntry.szWordCode);
                pEntry.szWord = strWord = this.ReplaceCode(WordCodeCpy);
                String[] ppToken = pEntry.szMeanings = new String[nMeaningsCount];
                szToken = szToken.substring(iGotToken + 1);
                int iPreIndex = iGotToken + 1;
                szToken = szToken + ";";
                i = 0;
                while (szToken.length() != 0) {
                    iGotToken = szToken.indexOf(";");
                    String szMyToken = szToken.substring(0, iGotToken);
                    szToken = szToken.substring(iGotToken + 1);
                    nToken = szMyToken.length();
                    char[] chrToken = new char[iGotToken];
                    szMyToken.getChars(0, iGotToken, chrToken, 0);
                    char[] chrppToken = new char[nToken];
                    Glossary.InternalMultiByteToWideChar(this.m_dfh.wMeaningCodePage, 0, chrToken, nToken, chrppToken, nToken);
                    ppToken[i] = String.valueOf(chrppToken);
                    ++i;
                }
                ppEntry[ipEntryIndex] = pEntry;
                return true;
            }
        }
        catch (Exception Err) {
            return false;
        }
        return false;
    }

    boolean FreeWordData(DICTDATAENTRY[] ppEntry, int iIndex) {
        if (ppEntry != null) {
            DICTDATAENTRY[] pEntry = ppEntry;
            pEntry[iIndex].szWordCode = null;
            pEntry[iIndex].szWord = null;
            String[] ppToken = pEntry[iIndex].szMeanings;
            for (int i = 0; i < pEntry[iIndex].nMeaningsCount; ++i) {
                if (ppToken[i] == null) continue;
                ppToken[i] = null;
            }
            pEntry[iIndex].szMeanings = null;
            pEntry = null;
            ppEntry[iIndex] = null;
        }
        return false;
    }

    int ReadIndexFile(CustomInputStream hIndexFile, String szIndexFile) {
        try {
            this.m_ifh.wSignature = GeneralUtils.hton(hIndexFile.readShort());
            this.m_ifh.wVersion = GeneralUtils.hton(hIndexFile.readShort());
            this.m_ifh.dwNumEntries = GeneralUtils.htonl(hIndexFile.readInt());
            this.m_ifh.nCharsStart = (short)(hIndexFile.readByte() & 0xFF);
            this.m_ifh.nCharsSize = (short)(hIndexFile.readByte() & 0xFF);
            return 0;
        }
        catch (Exception Err) {
            return -1;
        }
    }

    String GetCharData(char[] chrData) {
        String strData = "";
        String strTemp = new String(chrData);
        for (int i = 0; i < strTemp.length() && strTemp.charAt(i) != '\u0000'; ++i) {
            strData = strData + strTemp.charAt(i);
        }
        return strData;
    }

    String CodeToWord(int code) {
        switch (code) {
            case 1: {
                return this.GetCharData(this.m_dfh.GlossaryTextNoun);
            }
            case 2: {
                return this.GetCharData(this.m_dfh.GlossaryTextVerb);
            }
            case 3: {
                return this.GetCharData(this.m_dfh.GlossaryTextAdjective);
            }
            case 4: {
                return this.GetCharData(this.m_dfh.GlossaryTextAdverb);
            }
            case 5: {
                return this.GetCharData(this.m_dfh.GlossaryTextArticle);
            }
            case 6: {
                return this.GetCharData(this.m_dfh.GlossaryTextAuxiliary);
            }
            case 7: {
                return this.GetCharData(this.m_dfh.GlossaryTextConjunction);
            }
            case 8: {
                return this.GetCharData(this.m_dfh.GlossaryTextInterjection);
            }
            case 9: {
                return this.GetCharData(this.m_dfh.GlossaryTextPreposition);
            }
            case 10: {
                return this.GetCharData(this.m_dfh.GlossaryTextPronoun);
            }
            case 11: {
                return this.GetCharData(this.m_dfh.GlossaryTextPhrasalVerb);
            }
            case 12: {
                return this.GetCharData(this.m_dfh.GlossaryTextIdiomNoun);
            }
            case 13: {
                return this.GetCharData(this.m_dfh.GlossaryTextIdiomAdj);
            }
            case 14: {
                return this.GetCharData(this.m_dfh.GlossaryTextIdiomAdverb);
            }
            case 15: {
                return this.GetCharData(this.m_dfh.GlossaryTextPluralNoun);
            }
            case 16: {
                return this.GetCharData(this.m_dfh.GlossaryTextNounPlural);
            }
            case 17: {
                return this.GetCharData(this.m_dfh.GlossaryTextComputer);
            }
        }
        return "";
    }

    public Glossary(boolean blang) {
        this.m_dfh = new DICTDATAFILEHEADER();
        this.m_ifh = new DICTINDEXFILEHEADER();
        this.m_bLang = blang;
    }

    int GetCharIndex(char ch) {
        if (this.m_pCharsPointers == null || !this.m_bInitialized) {
            return -1;
        }
        String strAnsiCH = String.valueOf(ch);
        char AnsiCH = (strAnsiCH = strAnsiCH.toLowerCase()).charAt(0);
        if (AnsiCH < this.m_ifh.nCharsStart || AnsiCH >= this.m_ifh.nCharsStart + this.m_ifh.nCharsSize) {
            return -1;
        }
        int nRet = this.m_pCharsPointers[AnsiCH = (char)(AnsiCH - this.m_ifh.nCharsStart)];
        if (nRet == 0 && AnsiCH != '\u0000') {
            return -1;
        }
        return nRet;
    }

    int GetNextCharIndex(char ch) {
        int nRet = 0;
        if (this.m_pCharsPointers == null || !this.m_bInitialized) {
            return -1;
        }
        String strAnsiCH = String.valueOf(ch);
        char AnsiCH = (strAnsiCH = strAnsiCH.toLowerCase()).charAt(0);
        if (AnsiCH < this.m_ifh.nCharsStart || AnsiCH >= this.m_ifh.nCharsStart + this.m_ifh.nCharsSize) {
            return -1;
        }
        AnsiCH = (char)(AnsiCH - this.m_ifh.nCharsStart);
        while (AnsiCH < this.m_ifh.nCharsSize - 1 && (nRet = this.m_pCharsPointers[AnsiCH = (char)(AnsiCH + '\u0001')]) == 0) {
        }
        if (AnsiCH == this.m_ifh.nCharsSize - 1) {
            nRet = this.m_ifh.dwNumEntries - 1;
        }
        return nRet;
    }

    String ReplaceCode(String str) {
        int spcI = str.lastIndexOf(32);
        if (spcI == -1) {
            return str;
        }
        String code = str.substring(spcI + 1);
        String word = this.CodeToWord(Glossary.MyParseInt(code));
        if (word != "") {
            word = "(" + word + ")";
        }
        String ret = str;
        ret = ret.substring(0, spcI + 1);
        ret = ret + word;
        return ret;
    }

    public void CloseDatFile() {
        try {
            if (this.m_hDataFile != null) {
                this.m_hDataFile.close();
                this.m_hDataFile = null;
            }
        }
        catch (Exception Err) {
            Err.printStackTrace();
        }
    }
}

