/*
 * Decompiled with CFR 0.152.
 */
package GeneralLibs;

import GeneralLibs.CustomInputStream;
import GeneralLibs.GeneralUtils;
import java.io.DataInputStream;
import java.io.IOException;

public class CachedDataInputStream
implements CustomInputStream {
    String m_strFilePathName;
    byte[] m_bBuffer = null;
    int m_nSize;
    int m_nCurPos = -1;
    long F_Size = 0L;

    private DataInputStream LocChoose(String Path) {
        DataInputStream dis = null;
        dis = new DataInputStream(this.getClass().getResourceAsStream(Path));
        return dis;
    }

    public CachedDataInputStream(String strFilePathName) throws IOException {
        this.m_strFilePathName = strFilePathName;
        DataInputStream ds = this.LocChoose(strFilePathName);
        if (ds == null) {
            throw new IOException("Failed to open the file.");
        }
        this.F_Size = ds.available();
        this.m_nSize = (int)this.F_Size;
        this.m_bBuffer = new byte[this.m_nSize];
        ds.read(this.m_bBuffer);
        ds.close();
        ds = null;
        this.m_nCurPos = 0;
    }

    public void reset() throws IOException {
        this.m_nCurPos = 0;
    }

    public void skip(int nBytes) throws IOException {
        this.m_nCurPos += nBytes;
        if (this.m_nCurPos >= this.m_nSize || this.m_nCurPos < 0) {
            this.reset();
            throw new IOException("EOF reached");
        }
    }

    public void setPosition(int nBytes) throws IOException {
        this.m_nCurPos = nBytes;
        if (this.m_nCurPos >= this.m_nSize || this.m_nCurPos < 0) {
            this.reset();
            throw new IOException("EOF reached");
        }
    }

    public byte readByte() throws IOException {
        if (this.m_nCurPos >= this.m_nSize || this.m_nCurPos < 0) {
            this.reset();
            throw new IOException("EOF reached");
        }
        byte b = this.m_bBuffer[this.m_nCurPos++];
        return b;
    }

    public int read() throws IOException {
        if (this.m_nCurPos >= this.m_nSize || this.m_nCurPos < 0) {
            this.reset();
            throw new IOException("EOF reached");
        }
        int b = this.m_bBuffer[this.m_nCurPos++] & 0xFF;
        return b;
    }

    public int read(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.readByte();
        }
        return b.length;
    }

    public void close() throws IOException {
        this.m_bBuffer = null;
    }

    public short readShort() throws IOException {
        short s = 0;
        int first = this.read();
        int second = this.read();
        s = (short)(second & 0xFF | first << 8 & 0xFF00);
        return s;
    }

    public int readInt() throws IOException {
        byte[] b = new byte[]{this.readByte(), this.readByte(), this.readByte(), this.readByte()};
        return GeneralUtils.IntFromBufH(b, 0);
    }

    public int available() {
        return this.m_nSize - this.m_nCurPos;
    }

    public int getPosition() throws IOException {
        return this.m_nCurPos;
    }

    public int read(byte[] b, int iLen) throws IOException {
        return 0;
    }
}

