/*
 * Decompiled with CFR 0.152.
 */
package GeneralLibs;

public abstract class GeneralUtils {
    public static byte[] CloneByteArray(byte[] iarr) {
        if (iarr == null) {
            return null;
        }
        if (iarr.length < 1) {
            return null;
        }
        byte[] oarr = new byte[iarr.length];
        for (int i = 0; i < iarr.length; ++i) {
            oarr[i] = iarr[i];
        }
        return oarr;
    }

    public static int[] CloneIntArray(int[] iarr) {
        if (iarr == null) {
            return null;
        }
        if (iarr.length < 1) {
            return null;
        }
        int[] oarr = new int[iarr.length];
        for (int i = 0; i < iarr.length; ++i) {
            oarr[i] = iarr[i];
        }
        return oarr;
    }

    public static byte[] CombineByteArrays(byte[] barr1, byte[] barr2) {
        int i;
        if (barr1 == null || barr2 == null) {
            return null;
        }
        byte[] oarr = new byte[barr1.length + barr2.length];
        int j = 0;
        for (i = 0; i < barr1.length; ++i) {
            oarr[j++] = barr1[i];
        }
        for (i = 0; i < barr2.length; ++i) {
            oarr[j++] = barr2[i];
        }
        return oarr;
    }

    public static int[] CombineIntArrays(int[] barr1, int[] barr2) {
        int i;
        if (barr1 == null || barr2 == null) {
            return null;
        }
        int[] oarr = new int[barr1.length + barr2.length];
        int j = 0;
        for (i = 0; i < barr1.length; ++i) {
            oarr[j++] = barr1[i];
        }
        for (i = 0; i < barr2.length; ++i) {
            oarr[j++] = barr2[i];
        }
        return oarr;
    }

    public static int[] SetIntArraySize(int[] iarr, int nNewSize) {
        int[] oarr = new int[nNewSize];
        for (int i = 0; i < iarr.length && i < nNewSize; ++i) {
            oarr[i] = iarr[i];
        }
        return oarr;
    }

    public static int[] RemoveAtIndex(int[] iarr, int iIndex) {
        int j = 0;
        int[] oarr = new int[iarr.length - 1];
        for (int i = 0; i < iarr.length; ++i) {
            if (i == iIndex) continue;
            oarr[j++] = iarr[i];
        }
        return oarr;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static short hton(short in) {
        int bs;
        int out = 0;
        int iHMask = 65280;
        int iLMask = 255;
        int iin = in & 0xFFFF;
        int bf = (iHMask & iin) >> 8 & 0xFF;
        out = bs = iLMask & iin;
        out <<= 8;
        short sout = (short)(out |= bf);
        return sout;
    }

    public static int htonl(int in) {
        int out = 0;
        int iHMask = -65536;
        int iLMask = 65535;
        int iLow = (0xFFFF & GeneralUtils.hton((short)(iLMask & in))) << 16 & 0xFFFF0000;
        int iHigh = 0xFFFF & GeneralUtils.hton((short)(iLMask & in >> 16));
        out = iLow | iHigh;
        return out;
    }

    public static int IntFromBuf(byte[] b, int Offset) {
        int inum = 0;
        if (b.length < 4 + Offset) {
            return 0;
        }
        int itmp = 0xFF & b[3 + Offset];
        int imask = -16777216;
        inum |= imask & itmp << 24;
        itmp = 0xFF & b[2 + Offset];
        imask = 0xFF0000;
        inum |= imask & itmp << 16;
        itmp = 0xFF & b[1 + Offset];
        imask = 65280;
        inum |= imask & itmp << 8;
        itmp = 0xFF & b[0 + Offset];
        imask = 255;
        return inum |= imask & itmp;
    }

    public static int IntFromBufH(byte[] b, int Offset) {
        int inum = 0;
        if (b.length < 4 + Offset) {
            return 0;
        }
        int itmp = 0xFF & b[0 + Offset];
        int imask = -16777216;
        inum |= imask & itmp << 24;
        itmp = 0xFF & b[1 + Offset];
        imask = 0xFF0000;
        inum |= imask & itmp << 16;
        itmp = 0xFF & b[2 + Offset];
        imask = 65280;
        inum |= imask & itmp << 8;
        itmp = 0xFF & b[3 + Offset];
        imask = 255;
        return inum |= imask & itmp;
    }

    public static byte[] BufFromInt(int i) {
        byte[] b = new byte[]{(byte)(0xFF & i), (byte)(0xFF & i >> 8), (byte)(0xFF & i >> 16), (byte)(0xFF & i >> 24)};
        return b;
    }

    public static String IntFormatX(int i, int minl) {
        String str = Integer.toHexString(i);
        str = str.toUpperCase();
        while (str.length() < minl) {
            str = "0" + str;
        }
        return str;
    }

    public static String IntFormat(int i, int minl) {
        String str = Integer.toString(i);
        while (str.length() < minl) {
            str = "0" + str;
        }
        return str;
    }

    public static short LOWORD(int l) {
        return (short)l;
    }

    public static short HIWORD(int l) {
        return (short)(l >> 16 & 0xFFFF);
    }

    public static int GetRValue(int rgb) {
        return rgb & 0xFF;
    }

    public static int GetGValue(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int GetBValue(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int RGB(int r, int g, int b) {
        int rgb = 0;
        rgb = r & 0xFF;
        rgb |= (g & 0xFF) << 8 & 0xFF00;
        return rgb |= (b & 0xFF) << 16 & 0xFF0000;
    }

    public static int FindString(String[] strArr, String stToken) {
        for (int i = 0; i < strArr.length; ++i) {
            if (strArr[i].compareTo(stToken) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int FindInt(int[] iArr, int iToken) {
        for (int i = 0; i < iArr.length; ++i) {
            if (iArr[i] != iToken) continue;
            return i;
        }
        return -1;
    }
}

