/*
 * Decompiled with CFR 0.152.
 */
package GeneralLibs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class HashTableRS {
    public static int N_ITEMS_IN_RECORD = 10;
    int m_nSize = 0;
    String m_strRSName;
    RecordStore m_HashTableRS;

    private void CloseRecordStore(RecordStore rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public boolean Open(String strHashName, int nSize) throws RecordStoreException {
        this.m_strRSName = strHashName;
        Object bRecord = null;
        this.m_nSize = nSize;
        try {
            this.m_HashTableRS = RecordStore.openRecordStore((String)this.m_strRSName, (boolean)true);
            int nRecs = this.m_HashTableRS.getNumRecords();
            int j = this.m_nSize % N_ITEMS_IN_RECORD != 0 ? 1 : 0;
            if (nRecs == this.m_nSize / N_ITEMS_IN_RECORD + j) {
                return true;
            }
            if (nRecs != 0) {
                this.m_HashTableRS.closeRecordStore();
                RecordStore.deleteRecordStore((String)this.m_strRSName);
                this.m_HashTableRS = RecordStore.openRecordStore((String)this.m_strRSName, (boolean)true);
                return false;
            }
        }
        catch (RecordStoreException ex) {
            this.CloseRecordStore(this.m_HashTableRS);
            throw ex;
        }
        return false;
    }

    public boolean CreateEmpty(String strHashName, int nSize) throws RecordStoreException, IOException {
        this.m_strRSName = strHashName;
        byte[] bRecord = null;
        this.m_nSize = nSize;
        try {
            int iRecSz;
            DataOutputStream outputStreamSizes;
            ByteArrayOutputStream baosSizes;
            DataOutputStream outputStream;
            ByteArrayOutputStream baos;
            this.m_HashTableRS = RecordStore.openRecordStore((String)this.m_strRSName, (boolean)true);
            int nRecs = this.m_HashTableRS.getNumRecords();
            int j = this.m_nSize % N_ITEMS_IN_RECORD != 0 ? 1 : 0;
            if (nRecs == this.m_nSize / N_ITEMS_IN_RECORD + j) {
                return false;
            }
            if (nRecs != 0) {
                this.m_HashTableRS.closeRecordStore();
                RecordStore.deleteRecordStore((String)this.m_strRSName);
                this.m_HashTableRS = RecordStore.openRecordStore((String)this.m_strRSName, (boolean)true);
            }
            for (int i = 0; i < this.m_nSize / N_ITEMS_IN_RECORD; ++i) {
                baos = new ByteArrayOutputStream();
                outputStream = new DataOutputStream(baos);
                baosSizes = new ByteArrayOutputStream();
                outputStreamSizes = new DataOutputStream(baosSizes);
                iRecSz = N_ITEMS_IN_RECORD - 1;
                for (j = 0; j <= iRecSz; ++j) {
                    outputStream.writeInt(0);
                }
                bRecord = baos.toByteArray();
                this.m_HashTableRS.addRecord(bRecord, 0, bRecord.length);
            }
            if (this.m_nSize % N_ITEMS_IN_RECORD != 0) {
                baos = new ByteArrayOutputStream();
                outputStream = new DataOutputStream(baos);
                baosSizes = new ByteArrayOutputStream();
                outputStreamSizes = new DataOutputStream(baosSizes);
                iRecSz = N_ITEMS_IN_RECORD - 1;
                for (j = 0; j <= iRecSz; ++j) {
                    outputStream.writeInt(0);
                }
                bRecord = baos.toByteArray();
                this.m_HashTableRS.addRecord(bRecord, 0, bRecord.length);
            }
        }
        catch (RecordStoreException ex) {
            this.CloseRecordStore(this.m_HashTableRS);
            throw ex;
        }
        catch (IOException ex) {
            this.CloseRecordStore(this.m_HashTableRS);
            throw ex;
        }
        return true;
    }

    public boolean Create(String strHashName, Object[][] hashtable, HashObject emptyObj) throws RecordStoreException, IOException {
        this.m_strRSName = strHashName;
        byte[] bRecord = null;
        this.m_nSize = hashtable.length;
        int k = 0;
        try {
            Object[] llist;
            int iRecSz;
            DataOutputStream outputStreamSizes;
            ByteArrayOutputStream baosSizes;
            DataOutputStream outputStream;
            ByteArrayOutputStream baos;
            int i;
            this.m_HashTableRS = RecordStore.openRecordStore((String)this.m_strRSName, (boolean)true);
            int nRecs = this.m_HashTableRS.getNumRecords();
            int j = this.m_nSize % N_ITEMS_IN_RECORD != 0 ? 1 : 0;
            if (nRecs == this.m_nSize / N_ITEMS_IN_RECORD + j) {
                return false;
            }
            if (nRecs != 0) {
                this.m_HashTableRS.closeRecordStore();
                RecordStore.deleteRecordStore((String)this.m_strRSName);
                this.m_HashTableRS = RecordStore.openRecordStore((String)this.m_strRSName, (boolean)true);
            }
            for (i = 0; i < this.m_nSize / N_ITEMS_IN_RECORD; ++i) {
                baos = new ByteArrayOutputStream();
                outputStream = new DataOutputStream(baos);
                baosSizes = new ByteArrayOutputStream();
                outputStreamSizes = new DataOutputStream(baosSizes);
                iRecSz = N_ITEMS_IN_RECORD - 1;
                for (j = 0; j <= iRecSz; ++j) {
                    llist = hashtable[i * N_ITEMS_IN_RECORD + j];
                    if (llist != null) {
                        outputStream.writeInt(llist.length);
                        for (k = 0; k < llist.length; ++k) {
                            emptyObj.FillFromRaw(llist[k]);
                            emptyObj.writeStream(outputStream);
                        }
                        continue;
                    }
                    outputStream.writeInt(0);
                }
                bRecord = baos.toByteArray();
                this.m_HashTableRS.addRecord(bRecord, 0, bRecord.length);
            }
            if (this.m_nSize % N_ITEMS_IN_RECORD != 0) {
                baos = new ByteArrayOutputStream();
                outputStream = new DataOutputStream(baos);
                baosSizes = new ByteArrayOutputStream();
                outputStreamSizes = new DataOutputStream(baosSizes);
                iRecSz = (this.m_nSize - i * N_ITEMS_IN_RECORD) % N_ITEMS_IN_RECORD;
                --i;
                while (i * N_ITEMS_IN_RECORD + j < hashtable.length) {
                    llist = hashtable[i * N_ITEMS_IN_RECORD + j];
                    if (llist != null) {
                        outputStream.writeInt(llist.length);
                        for (k = 0; k < llist.length; ++k) {
                            emptyObj.FillFromRaw(llist[k]);
                            emptyObj.writeStream(outputStream);
                        }
                    } else {
                        outputStream.writeInt(0);
                    }
                    ++j;
                }
                bRecord = baos.toByteArray();
                this.m_HashTableRS.addRecord(bRecord, 0, bRecord.length);
            }
        }
        catch (RecordStoreException ex) {
            this.CloseRecordStore(this.m_HashTableRS);
            throw ex;
        }
        catch (IOException ex) {
            this.CloseRecordStore(this.m_HashTableRS);
            throw ex;
        }
        return true;
    }

    public boolean Add(int iHashIndex, HashObject newObj, HashObject EmptyObj) throws IOException, RecordStoreException {
        int i;
        int iLListItemsCnt;
        int iReadIndex;
        if (iHashIndex >= this.m_nSize) {
            iHashIndex %= this.m_nSize;
        }
        int iDataRecordIndex = iHashIndex / N_ITEMS_IN_RECORD + 1;
        byte[] bRecord = null;
        int nRecs = this.m_HashTableRS.getNumRecords();
        if (iDataRecordIndex > nRecs) {
            return false;
        }
        bRecord = this.m_HashTableRS.getRecord(iDataRecordIndex);
        ByteArrayInputStream bais = new ByteArrayInputStream(bRecord);
        DataInputStream inputStream = new DataInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(baos);
        for (iReadIndex = (iDataRecordIndex - 1) * N_ITEMS_IN_RECORD; iReadIndex < iHashIndex; ++iReadIndex) {
            iLListItemsCnt = inputStream.readInt();
            outputStream.writeInt(iLListItemsCnt);
            for (i = 0; i < iLListItemsCnt; ++i) {
                EmptyObj.readStream(inputStream);
                EmptyObj.writeStream(outputStream);
            }
        }
        iLListItemsCnt = inputStream.readInt();
        outputStream.writeInt(iLListItemsCnt + 1);
        for (i = 0; i < iLListItemsCnt; ++i) {
            EmptyObj.readStream(inputStream);
            EmptyObj.writeStream(outputStream);
        }
        newObj.writeStream(outputStream);
        ++iReadIndex;
        while (iReadIndex % N_ITEMS_IN_RECORD != 0) {
            iLListItemsCnt = inputStream.readInt();
            outputStream.writeInt(iLListItemsCnt);
            for (i = 0; i < iLListItemsCnt; ++i) {
                EmptyObj.readStream(inputStream);
                EmptyObj.writeStream(outputStream);
            }
            ++iReadIndex;
        }
        bRecord = baos.toByteArray();
        this.m_HashTableRS.setRecord(iDataRecordIndex, bRecord, 0, bRecord.length);
        return true;
    }

    public boolean HSearch(Object ObjKey, HashObject HashObj) throws IOException, RecordStoreException {
        int i;
        int iLListItemsCnt;
        int iHashIndex = HashObj.Hash(ObjKey, this.m_nSize);
        if (iHashIndex >= this.m_nSize) {
            iHashIndex %= this.m_nSize;
        }
        int iDataRecordIndex = iHashIndex / N_ITEMS_IN_RECORD + 1;
        byte[] bRecord = null;
        int nRecs = this.m_HashTableRS.getNumRecords();
        if (iDataRecordIndex > nRecs) {
            return false;
        }
        bRecord = this.m_HashTableRS.getRecord(iDataRecordIndex);
        ByteArrayInputStream bais = new ByteArrayInputStream(bRecord);
        DataInputStream inputStream = new DataInputStream(bais);
        for (int iReadIndex = (iDataRecordIndex - 1) * N_ITEMS_IN_RECORD; iReadIndex < iHashIndex; ++iReadIndex) {
            iLListItemsCnt = inputStream.readInt();
            for (i = 0; i < iLListItemsCnt; ++i) {
                HashObj.readStream(inputStream);
            }
        }
        iLListItemsCnt = inputStream.readInt();
        for (i = 0; i < iLListItemsCnt; ++i) {
            HashObj.readStream(inputStream);
            if (!HashObj.IsEqualKey(ObjKey)) continue;
            return true;
        }
        return false;
    }

    public static interface HashObject {
        public void writeStream(DataOutputStream var1) throws IOException;

        public void readStream(DataInputStream var1) throws IOException;

        public int Hash(Object var1, int var2);

        public boolean IsEqualKey(Object var1);

        public void FillFromRaw(Object var1);
    }
}

