/*
 * Decompiled with CFR 0.152.
 */
package GeneralLibs;

import DictPKG.ErrorHandler;
import GeneralLibs.CustomInputStream;
import GeneralLibs.GeneralUtils;
import java.io.DataInputStream;
import java.io.IOException;

public class PartFileInputStream
implements CustomInputStream {
    String m_strFilePathName;
    int m_nParts = -1;
    int m_nPartSz = -1;
    int m_nCurFilePos = -1;
    int m_nTotSz = -1;
    int m_nLastPartSz = -1;
    int m_nCurPartIndex = -1;
    DataInputStream m_disCurPart = null;
    byte[] m_bBuffer = null;
    long F_Size = 0L;
    ErrorHandler instance = new ErrorHandler();

    private DataInputStream LocChoose(String Path) {
        DataInputStream dis = null;
        dis = new DataInputStream(this.getClass().getResourceAsStream(Path));
        try {
            this.F_Size = dis.available();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return dis;
    }

    public PartFileInputStream(String strFilePathName) throws IOException {
        this.m_strFilePathName = strFilePathName;
        DataInputStream dis = this.LocChoose(this.m_strFilePathName + "0");
        if (this.F_Size <= 0L) {
            dis.close();
            dis = null;
            return;
        }
        this.m_nParts = GeneralUtils.htonl(dis.readInt());
        this.m_nPartSz = GeneralUtils.htonl(dis.readInt());
        this.m_nLastPartSz = GeneralUtils.htonl(dis.readInt());
        dis.close();
        dis = null;
        this.m_nCurFilePos = 0;
        this.m_nTotSz = (this.m_nParts - 1) * this.m_nPartSz + this.m_nLastPartSz;
        this.m_disCurPart = this.LocChoose(this.m_strFilePathName + "1");
        this.m_nCurPartIndex = 0;
        this.m_bBuffer = new byte[this.m_nPartSz];
        this.m_disCurPart.read(this.m_bBuffer);
        this.m_disCurPart.close();
        this.m_disCurPart = null;
    }

    public void reset() throws IOException {
        this.m_nCurFilePos = 0;
        int nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
        if (this.m_nCurPartIndex != nCurPartIndex) {
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_nCurPartIndex = nCurPartIndex;
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
    }

    public void skip(int nBytes) throws IOException {
        this.m_nCurFilePos += nBytes;
        if (this.m_nCurFilePos < 0 || this.m_nCurFilePos >= this.m_nTotSz) {
            this.reset();
            throw new IOException("Invalid file position!");
        }
        int nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        if (nCurPartIndex != this.m_nCurPartIndex) {
            this.m_nCurPartIndex = nCurPartIndex;
            if (this.m_disCurPart != null) {
                this.m_disCurPart.close();
            }
            this.m_disCurPart = null;
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
    }

    public void setPosition(int nBytes) throws IOException {
        this.m_nCurFilePos = nBytes;
        if (this.m_nCurFilePos < 0 || this.m_nCurFilePos >= this.m_nTotSz) {
            this.reset();
            throw new IOException("Invalid file position!");
        }
        int nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        if (nCurPartIndex != this.m_nCurPartIndex) {
            this.m_nCurPartIndex = nCurPartIndex;
            if (this.m_disCurPart != null) {
                this.m_disCurPart.close();
            }
            this.m_disCurPart = null;
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
    }

    public byte readByte() throws IOException {
        byte b = 0;
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        if (this.m_nCurFilePos >= this.m_nTotSz) {
            throw new IOException("EOF exception!");
        }
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        b = this.m_bBuffer[nCurPartPos];
        ++this.m_nCurFilePos;
        if (this.m_nCurFilePos % this.m_nPartSz == 0) {
            int nCurPartIndex;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
        return b;
    }

    public int read() throws IOException {
        int b = 0;
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        if (this.m_nCurFilePos >= this.m_nTotSz) {
            throw new IOException("EOF exception!");
        }
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        b = this.m_bBuffer[nCurPartPos] & 0xFF;
        ++this.m_nCurFilePos;
        if (this.m_nCurFilePos % this.m_nPartSz == 0) {
            int nCurPartIndex;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        for (int i = 0; i < b.length; ++i) {
            int nCurPartIndex;
            if (this.m_nCurFilePos >= this.m_nTotSz) {
                throw new IOException("EOF exception!");
            }
            int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
            b[i] = this.m_bBuffer[nCurPartPos];
            ++this.m_nCurFilePos;
            if (this.m_nCurFilePos % this.m_nPartSz != 0) continue;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
        return 0;
    }

    public void close() throws IOException {
        this.m_nParts = -1;
        this.m_nPartSz = -1;
        this.m_nCurFilePos = -1;
        this.m_nTotSz = -1;
        this.m_nLastPartSz = -1;
        if (this.m_disCurPart != null) {
            this.m_disCurPart.close();
        }
        this.m_disCurPart = null;
    }

    public short readShort() throws IOException {
        short s = 0;
        int first = this.read();
        int second = this.read();
        s = (short)(second & 0xFF | first << 8 & 0xFF00);
        return s;
    }

    public int readInt() throws IOException {
        byte[] b = new byte[]{this.readByte(), this.readByte(), this.readByte(), this.readByte()};
        return GeneralUtils.IntFromBufH(b, 0);
    }

    public int available() {
        return this.m_nTotSz - this.m_nCurFilePos;
    }

    public int getPosition() {
        return this.m_nCurFilePos;
    }

    public int read(byte[] b, int iLen) throws IOException {
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        for (int i = 0; i < iLen; ++i) {
            int nCurPartIndex;
            if (this.m_nCurFilePos >= this.m_nTotSz) {
                throw new IOException("EOF exception!");
            }
            int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
            b[i] = this.m_bBuffer[nCurPartPos];
            ++this.m_nCurFilePos;
            if (this.m_nCurFilePos % this.m_nPartSz != 0) continue;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            this.m_disCurPart = this.LocChoose(this.m_strFilePathName + (nCurPartIndex + 1));
            this.m_disCurPart.read(this.m_bBuffer);
            this.m_disCurPart.close();
            this.m_disCurPart = null;
        }
        return 0;
    }
}

