/*
 * Decompiled with CFR 0.152.
 */
package GeneralLibs;

import GeneralLibs.CustomInputStream;
import GeneralLibs.GeneralUtils;
import GeneralLibs.PartFileInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class PartFileInputStreamRS
implements CustomInputStream {
    String m_strFilePathName;
    int m_nParts = -1;
    int m_nPartSz = -1;
    int m_nCurFilePos = -1;
    int m_nTotSz = -1;
    int m_nLastPartSz = -1;
    int m_nCurPartIndex = -1;
    DataInputStream m_disCurPart = null;
    int NO_CACHED_PARTS = 5;
    RecordStore m_curRS;
    byte[] m_bBuffer = null;

    public PartFileInputStreamRS(String strFilePathName) throws IOException, RecordStoreFullException {
        this.m_strFilePathName = strFilePathName;
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(this.m_strFilePathName + "0"));
        if (dis.available() <= 0) {
            dis.close();
            dis = null;
            return;
        }
        this.m_nParts = GeneralUtils.htonl(dis.readInt());
        this.m_nPartSz = GeneralUtils.htonl(dis.readInt());
        this.m_nLastPartSz = GeneralUtils.htonl(dis.readInt());
        dis.close();
        dis = null;
        this.m_nCurFilePos = 0;
        this.m_nTotSz = (this.m_nParts - 1) * this.m_nPartSz + this.m_nLastPartSz;
        this.m_nCurPartIndex = 0;
        this.m_bBuffer = new byte[this.m_nPartSz];
        try {
            this.m_curRS = RecordStore.openRecordStore((String)this.m_strFilePathName, (boolean)true);
            int nRecs = this.m_curRS.getNumRecords();
            if (nRecs != this.m_nParts) {
                this.PopulateRS();
            }
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        try {
            this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    void PopulateRS() throws IOException, RecordStoreFullException {
        try {
            this.m_curRS.closeRecordStore();
            RecordStore.deleteRecordStore((String)this.m_strFilePathName);
            this.m_curRS = RecordStore.openRecordStore((String)this.m_strFilePathName, (boolean)true);
            for (int i = 0; i < this.m_nParts; ++i) {
                InputStream m_disCurPart = this.getClass().getResourceAsStream(this.m_strFilePathName + (i + 1));
                int nSize = m_disCurPart.available();
                m_disCurPart.read(this.m_bBuffer);
                this.m_curRS.addRecord(this.m_bBuffer, 0, nSize);
                m_disCurPart.close();
                Object var3_5 = null;
            }
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void reset() throws IOException {
        this.m_nCurFilePos = 0;
        int nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
        if (this.m_nCurPartIndex != nCurPartIndex) {
            this.m_nCurPartIndex = nCurPartIndex;
            try {
                this.m_curRS.getRecord(nCurPartIndex + 1, this.m_bBuffer, 0);
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void skip(int nBytes) throws IOException {
        this.m_nCurFilePos += nBytes;
        if (this.m_nCurFilePos < 0 || this.m_nCurFilePos >= this.m_nTotSz) {
            throw new IOException("Invalid file position!");
        }
        int nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        if (nCurPartIndex != this.m_nCurPartIndex) {
            this.m_nCurPartIndex = nCurPartIndex;
            try {
                this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setPosition(int nBytes) throws IOException {
        this.m_nCurFilePos = nBytes;
        if (this.m_nCurFilePos < 0 || this.m_nCurFilePos >= this.m_nTotSz) {
            throw new IOException("Invalid file position!");
        }
        int nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        if (nCurPartIndex != this.m_nCurPartIndex) {
            this.m_nCurPartIndex = nCurPartIndex;
            try {
                this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public byte readByte() throws IOException {
        byte b = 0;
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        if (this.m_nCurFilePos >= this.m_nTotSz) {
            throw new IOException("EOF exception!");
        }
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        b = this.m_bBuffer[nCurPartPos];
        ++this.m_nCurFilePos;
        if (this.m_nCurFilePos % this.m_nPartSz == 0) {
            int nCurPartIndex;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            try {
                this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        return b;
    }

    public int read() throws IOException {
        int b = 0;
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        if (this.m_nCurFilePos >= this.m_nTotSz) {
            throw new IOException("EOF exception!");
        }
        int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
        b = this.m_bBuffer[nCurPartPos] & 0xFF;
        ++this.m_nCurFilePos;
        if (this.m_nCurFilePos % this.m_nPartSz == 0) {
            int nCurPartIndex;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            try {
                this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        for (int i = 0; i < b.length; ++i) {
            int nCurPartIndex;
            if (this.m_nCurFilePos >= this.m_nTotSz) {
                throw new IOException("EOF exception!");
            }
            int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
            b[i] = this.m_bBuffer[nCurPartPos];
            ++this.m_nCurFilePos;
            if (this.m_nCurFilePos % this.m_nPartSz != 0) continue;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            try {
                this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
                continue;
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    public void close() throws IOException {
        this.m_nParts = -1;
        this.m_nPartSz = -1;
        this.m_nCurFilePos = -1;
        this.m_nTotSz = -1;
        this.m_nLastPartSz = -1;
        if (this.m_disCurPart != null) {
            this.m_disCurPart.close();
        }
        this.m_disCurPart = null;
        if (this.m_curRS != null) {
            try {
                this.m_curRS.closeRecordStore();
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        this.m_curRS = null;
    }

    public short readShort() throws IOException {
        short s = 0;
        int first = this.read();
        int second = this.read();
        s = (short)(second & 0xFF | first << 8 & 0xFF00);
        return s;
    }

    public int readInt() throws IOException {
        byte[] b = new byte[]{this.readByte(), this.readByte(), this.readByte(), this.readByte()};
        return GeneralUtils.IntFromBufH(b, 0);
    }

    public int available() {
        return this.m_nTotSz - this.m_nCurFilePos;
    }

    public int getPosition() {
        return this.m_nCurFilePos;
    }

    public static CustomInputStream Create(String strFilePathName) throws IOException {
        CustomInputStream newObj = null;
        try {
            newObj = new PartFileInputStreamRS(strFilePathName);
        }
        catch (RecordStoreFullException ex) {
            try {
                if (newObj != null) {
                    PartFileInputStreamRS pRSObj = newObj;
                    if (pRSObj.m_curRS != null) {
                        pRSObj.m_curRS.closeRecordStore();
                    }
                }
                RecordStore.deleteRecordStore((String)strFilePathName);
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            newObj = new PartFileInputStream(strFilePathName);
        }
        return newObj;
    }

    public int read(byte[] b, int iLen) throws IOException {
        if (this.m_nParts <= 0 || this.m_nPartSz <= 0 || this.m_nCurFilePos < 0) {
            throw new IOException("File not open!");
        }
        for (int i = 0; i < iLen; ++i) {
            int nCurPartIndex;
            if (this.m_nCurFilePos >= this.m_nTotSz) {
                throw new IOException("EOF exception!");
            }
            int nCurPartPos = this.m_nCurFilePos % this.m_nPartSz;
            b[i] = this.m_bBuffer[nCurPartPos];
            ++this.m_nCurFilePos;
            if (this.m_nCurFilePos % this.m_nPartSz != 0) continue;
            this.m_nCurPartIndex = nCurPartIndex = this.m_nCurFilePos / this.m_nPartSz;
            try {
                this.m_curRS.getRecord(this.m_nCurPartIndex + 1, this.m_bBuffer, 0);
                continue;
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (RecordStoreNotOpenException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }
}

