/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import MobmeControls.IMobeEditListener;
import MobmeControls.MobmeForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeEdit
extends CustomComponent
implements CommandListener,
Runnable {
    int Bg_Color = 15266040;
    String m_strTitle = "";
    String m_strEdit = "";
    Displayable m_Parent = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    public boolean m_bIsTraversedOut = true;
    Font m_F;
    int m_iPos;
    int m_iCaretPos;
    public boolean m_bIsDrawCaret;
    boolean m_bIsHasFocus;
    int m_iTxtXScroll;
    long m_iLastWriteTime = -1L;
    boolean m_bIsDrawBackRect = false;
    boolean m_bNewSearch = false;
    boolean m_bIsScrolling = true;
    boolean m_bCanUpdate = false;
    int m_iScreenWidth = 0;
    Alert report;
    IMobeEditListener m_ListenerForDirection = null;
    MobmeForm Container = null;
    private boolean m_bIsNumMode = false;
    private char[][] m_CurKeyMap = null;
    private char[][] SamsungKeyMapEng = new char[][]{{'.', ',', '-', '?', '!', '\'', '@', ':', '1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}, {'*'}, {'0', '+'}, {' '}};
    private char[][] NumKeyMap = new char[][]{{'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {'\u0000'}, {'0'}, {'\u0000'}};
    private char[][] SamsungKeyMapAra = new char[][]{{'.', ',', '-', '?', '!', '\'', '@', ':', '1'}, {'\u0628', '\u062a', '\u0629', '\u062b', '2'}, {'\u0627', '\u0623', '\u0625', '\u0622', '\u0621', '\u0626', '\u0624', '3'}, {'\u0633', '\u0634', '\u0635', '\u0636', '4'}, {'\u062f', '\u0630', '\u0631', '\u0632', '5'}, {'\u062c', '\u062d', '\u062e', '6'}, {'\u0646', '\u0647', '\u0648', '\u064a', '\u0649', '7'}, {'\u0641', '\u0642', '\u0643', '\u0644', '\u0645', '8'}, {'\u0637', '\u0638', '\u0639', '\u063a', '9'}, {'*'}, {'0', '+'}, {' '}};

    public MobmeEdit(String Title, Displayable parent, Display display, Font f, boolean bIsArabic) {
        this.m_strTitle = Title;
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_iPos = -1;
        this.m_iCaretPos = 0;
        this.m_bIsDrawCaret = true;
        this.m_bIsHasFocus = false;
        this.m_iTxtXScroll = 0;
        this.m_iScreenWidth = parent.getWidth();
        new Thread(this).start();
        new Thread(new CaretFlashingThread()).start();
        this.m_CurKeyMap = this.m_bIsArabic ? this.SamsungKeyMapAra : this.SamsungKeyMapEng;
    }

    void DisplayAlert(String strMSG) {
        this.report = new Alert("Sorry", null, null, null);
        this.report.setTimeout(-2);
        this.report.setType(AlertType.ERROR);
        this.report.setString(strMSG);
        this.m_Display.setCurrent((Displayable)this.report);
    }

    public void SetListenerForDirection(IMobeEditListener MyListener) {
        this.m_ListenerForDirection = MyListener;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_F.getHeight() + 4;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_F.getHeight() + 4;
    }

    public int getPreferredHeight() {
        return this.m_F.getHeight() + 4;
    }

    protected void paint(Graphics graphics, int w, int h) {
        try {
            int xCaret;
            long iCurTime;
            int oldC = graphics.getColor();
            Font oldF = Font.getDefaultFont();
            graphics.setFont(null);
            int iFontHight = oldF.getHeight();
            graphics.setColor(this.Bg_Color);
            graphics.fillRect(0, 0, w, h);
            graphics.setColor(0);
            graphics.drawRect(1, 1, w - 5, h - 2);
            int xUnit = 3;
            int yUnit = 3;
            int TrWidth = (h - 4) / 2;
            graphics.setColor(oldC);
            boolean bIsMultiPressing = this.m_iLastWriteTime != -1L ? (iCurTime = System.currentTimeMillis()) - this.m_iLastWriteTime < 2500L : false;
            if (this.m_iCaretPos > this.m_strEdit.length()) {
                this.m_iCaretPos = this.m_strEdit.length();
            }
            String strEdit = new String(this.m_strEdit);
            if (this.m_bIsArabic) {
                strEdit = ArabicUtils.ArabicStringNoReversal(strEdit);
            }
            char cLast = '\u0000';
            if (bIsMultiPressing) {
                cLast = strEdit.charAt(this.m_iCaretPos - 1);
            }
            if (strEdit.length() <= 0) {
                xCaret = 0;
            } else {
                String stBeforeCaret = strEdit.substring(0, this.m_iCaretPos);
                xCaret = oldF.stringWidth(ArabicUtils.ArabicStringNoReversal(stBeforeCaret));
            }
            if (xCaret + 8 - this.m_iTxtXScroll > w - 14) {
                this.m_iTxtXScroll += 10;
            }
            if (xCaret + 8 - this.m_iTxtXScroll < 8) {
                this.m_iTxtXScroll -= 10;
            }
            if (this.m_iTxtXScroll < 0) {
                this.m_iTxtXScroll = 0;
            }
            if (cLast != '\u0000' && this.m_bIsDrawBackRect) {
                String strLast = "" + cLast;
                int oldc = graphics.getColor();
                graphics.setColor(0xFFFF00);
                if (this.m_bIsArabic) {
                    int iCharWidth = oldF.stringWidth(strLast);
                    graphics.fillRect(w - 8 - xCaret + this.m_iTxtXScroll, 2, iCharWidth, iFontHight + 1);
                } else {
                    int iCharWidth = oldF.stringWidth(strLast);
                    graphics.fillRect(5 + xCaret - iCharWidth - this.m_iTxtXScroll, 2, iCharWidth, iFontHight + 1);
                }
                graphics.setColor(oldc);
            }
            if (strEdit.length() > 0) {
                if (this.m_bIsArabic) {
                    graphics.setClip(7, 2, w - 7 - 7, h - 2 - 2);
                    if (strEdit.endsWith("(") || strEdit.endsWith(")")) {
                        graphics.drawSubstring(ArabicUtils.ArabicStringNoReversal(strEdit), 0, strEdit.length() - 1, w - 8 + this.m_iTxtXScroll, 3, 24);
                        graphics.drawString("(", w - 8 + this.m_iTxtXScroll - graphics.getFont().stringWidth(strEdit) + graphics.getFont().stringWidth("("), 3, 24);
                    } else {
                        graphics.drawString(ArabicUtils.ArabicStringNoReversal(strEdit), w - 8 + this.m_iTxtXScroll, 3, 24);
                    }
                } else {
                    graphics.drawString(strEdit, 5 - this.m_iTxtXScroll, 3, 20);
                }
            }
            if (this.IsFocused() && this.m_bIsDrawCaret) {
                if (this.m_bIsArabic) {
                    graphics.drawLine(w - xCaret - 8 + this.m_iTxtXScroll, 2, w - xCaret - 8 + this.m_iTxtXScroll, iFontHight + 3);
                } else {
                    graphics.drawLine(xCaret + 5 - this.m_iTxtXScroll, 2, xCaret + 5 - this.m_iTxtXScroll, iFontHight + 3);
                }
            }
            graphics.setColor(oldC);
            graphics.setFont(oldF);
        }
        catch (Exception ex) {
            String strErr = "Error inEdit Paint\t" + ex.getMessage();
            ex.printStackTrace();
        }
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode >= 48 && keyCode <= 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyCode == 35 || keyCode == -8) {
            if (this.m_strEdit.length() > 0 && this.m_iCaretPos > 0) {
                String before = this.m_strEdit.substring(0, this.m_iCaretPos - 1);
                String after = this.m_strEdit.substring(this.m_iCaretPos);
                this.m_strEdit = before + after;
                --this.m_iCaretPos;
            }
            this.m_iLastWriteTime = -1L;
            this.rePaint();
            if (this.m_ListenerForDirection != null && this.m_strEdit.length() > 0) {
                this.m_ListenerForDirection.OnEditChange(this.m_strEdit);
            }
            this.m_bIsScrolling = false;
        } else {
            char cLast = '\u0000';
            String before = "";
            String after = "";
            if (this.m_iLastWriteTime != -1L) {
                long iCurTime = System.currentTimeMillis();
                if (!this.m_bIsNumMode && iCurTime - this.m_iLastWriteTime < 2500L) {
                    char c;
                    if (this.m_strEdit.length() >= 1) {
                        if (this.m_iCaretPos >= 1) {
                            before = this.m_strEdit.substring(0, this.m_iCaretPos - 1);
                            cLast = this.m_strEdit.charAt(this.m_iCaretPos - 1);
                        }
                        after = this.m_strEdit.substring(this.m_iCaretPos);
                        this.m_strEdit = before;
                    }
                    if ((c = this.MapKeyToChar(keyCode, cLast)) != '\u0000') {
                        this.m_strEdit = this.m_strEdit + c + after;
                        this.m_iLastWriteTime = System.currentTimeMillis();
                    } else {
                        this.m_strEdit = this.m_strEdit + cLast + after;
                    }
                } else {
                    char c;
                    if (this.m_strEdit.length() >= 1) {
                        before = this.m_strEdit.substring(0, this.m_iCaretPos);
                        after = this.m_strEdit.substring(this.m_iCaretPos);
                        this.m_strEdit = before;
                    }
                    if ((c = this.MapKeyToChar(keyCode, '\u0000')) != '\u0000') {
                        this.m_strEdit = this.m_strEdit + c + after;
                        ++this.m_iCaretPos;
                        if (!this.m_bIsNumMode) {
                            this.m_iLastWriteTime = System.currentTimeMillis();
                        }
                    }
                }
            } else {
                char c;
                if (this.m_strEdit.length() >= 1) {
                    before = this.m_strEdit.substring(0, this.m_iCaretPos);
                    after = this.m_strEdit.substring(this.m_iCaretPos);
                    this.m_strEdit = before;
                }
                if ((c = this.MapKeyToChar(keyCode, '\u0000')) != '\u0000') {
                    this.m_strEdit = this.m_strEdit + c + after;
                    ++this.m_iCaretPos;
                    if (!this.m_bIsNumMode) {
                        this.m_iLastWriteTime = System.currentTimeMillis();
                    }
                    if (this.m_bIsScrolling && keyCode != 42) {
                        this.m_bIsScrolling = false;
                        if (this.m_strEdit.length() > 1) {
                            this.m_strEdit = this.m_strEdit.substring(this.m_strEdit.length() - 1);
                        }
                    }
                }
            }
            this.m_bIsDrawBackRect = true;
            this.rePaint();
        }
    }

    public String GetString() {
        return this.m_strEdit;
    }

    public void SetString(String strIn) {
        this.m_strEdit = strIn;
        this.m_iCaretPos = this.m_F.stringWidth(this.m_strEdit);
        this.rePaint();
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    private char MapKeyToChar(int keyCode, char cPrev) {
        int iRowIndex = this.GetRowIndex(keyCode);
        char c = '\u0000';
        if (iRowIndex == -1) {
            return c;
        }
        if (cPrev != '\u0000') {
            int cLastIndex = this.GetCharIndex(iRowIndex, cPrev);
            if (cLastIndex == -1) {
                this.m_strEdit = this.m_strEdit + cPrev;
                ++this.m_iCaretPos;
                c = this.m_CurKeyMap[iRowIndex][0];
                this.m_bNewSearch = true;
            } else {
                c = cLastIndex == this.m_CurKeyMap[iRowIndex].length - 1 ? this.m_CurKeyMap[iRowIndex][0] : this.m_CurKeyMap[iRowIndex][cLastIndex + 1];
            }
        } else {
            c = this.m_CurKeyMap[iRowIndex][0];
        }
        return c;
    }

    private int GetCharIndex(int iRowIndex, char cPrev) {
        if (iRowIndex < 0 || iRowIndex >= this.m_CurKeyMap.length) {
            return -1;
        }
        char[] Row = null;
        Row = this.m_CurKeyMap[iRowIndex];
        for (int i = 0; i < Row.length; ++i) {
            if (Row[i] != cPrev) continue;
            return i;
        }
        return -1;
    }

    private int GetRowIndex(int keyCode) {
        int iRowIndex = -1;
        switch (keyCode) {
            case 48: {
                iRowIndex = 10;
                break;
            }
            case 49: {
                iRowIndex = 0;
                break;
            }
            case 50: {
                iRowIndex = 1;
                break;
            }
            case 51: {
                iRowIndex = 2;
                break;
            }
            case 52: {
                iRowIndex = 3;
                break;
            }
            case 53: {
                iRowIndex = 4;
                break;
            }
            case 54: {
                iRowIndex = 5;
                break;
            }
            case 55: {
                iRowIndex = 6;
                break;
            }
            case 56: {
                iRowIndex = 7;
                break;
            }
            case 57: {
                iRowIndex = 8;
                break;
            }
            case 42: {
                iRowIndex = 11;
                break;
            }
            default: {
                return -1;
            }
        }
        return iRowIndex;
    }

    public void run() {
        try {
            int i = -1;
            while (true) {
                long iCurTime;
                Thread.sleep(150L);
                if (this.m_iLastWriteTime == -1L) {
                    i = -1;
                    continue;
                }
                if (++i % 4 == 0) {
                    i = 0;
                }
                if ((iCurTime = System.currentTimeMillis()) - this.m_iLastWriteTime > 2500L) {
                    this.m_iLastWriteTime = -1L;
                    this.m_bIsDrawBackRect = false;
                    i = -1;
                    this.m_bCanUpdate = true;
                }
                this.rePaint();
                if (!this.m_bCanUpdate) continue;
                this.m_bCanUpdate = false;
                this.m_ListenerForDirection.OnEditChange(this.m_strEdit);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.m_bIsHasFocus = true;
        if (this.m_bIsArabic) {
            switch (dir) {
                case 6: {
                    if (this.m_ListenerForDirection != null) {
                        this.m_ListenerForDirection.OnPressNext();
                    }
                    this.m_bIsScrolling = true;
                    return true;
                }
                case 1: {
                    if (this.m_ListenerForDirection != null) {
                        this.m_ListenerForDirection.OnPressPrevious();
                    }
                    this.m_bIsScrolling = true;
                    return true;
                }
                case 2: {
                    if (this.m_iCaretPos < this.m_strEdit.length()) {
                        ++this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                    break;
                }
                case 5: {
                    if (this.m_iCaretPos > 0) {
                        --this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                }
            }
        } else {
            switch (dir) {
                case 6: {
                    if (this.m_ListenerForDirection != null) {
                        this.m_ListenerForDirection.OnPressNext();
                    }
                    this.m_bIsScrolling = true;
                    return true;
                }
                case 1: {
                    if (this.m_ListenerForDirection != null) {
                        this.m_ListenerForDirection.OnPressPrevious();
                    }
                    this.m_bIsScrolling = true;
                    return true;
                }
                case 5: {
                    if (this.m_iCaretPos < this.m_strEdit.length()) {
                        ++this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                    break;
                }
                case 2: {
                    if (this.m_iCaretPos > 0) {
                        --this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                }
            }
        }
        return true;
    }

    protected void traverseOut() {
        this.m_bIsTraversedOut = true;
        this.m_bIsHasFocus = false;
    }

    public void SetKeyAction(MobmeForm ContainerForm) {
    }

    public void FocusIsGained() {
    }

    void SetNumberInputMode(boolean b) {
        this.m_bIsNumMode = b;
        this.m_CurKeyMap = !this.m_bIsNumMode ? (this.m_bIsArabic ? this.SamsungKeyMapAra : this.SamsungKeyMapEng) : this.NumKeyMap;
    }

    class CaretFlashingThread
    implements Runnable {
        CaretFlashingThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(500L);
                        MobmeEdit.this.m_bIsDrawCaret = !MobmeEdit.this.m_bIsDrawCaret;
                        MobmeEdit.this.rePaint();
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

