/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.CustomComponent;
import MobmeControls.IClockCalculator;
import MobmeControls.MobmeChoice;
import MobmeControls.MobmeNumChoice;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeForm
extends Canvas
implements CommandListener {
    private String m_RawTitle = "";
    private boolean m_bIsDrawClock = false;
    public IClockCalculator m_ClockCalc = null;
    private Vector CommandList = new Vector();
    private Vector DisabledItems = new Vector();
    int m_CommandNum = 0;
    int m_Height = 0;
    int m_Width = 0;
    int m_DisplayableNum = 0;
    public int m_iPad = 4;
    public static String DEBUG = "";
    protected Vector components = new Vector();
    private Vector VisibleComponents = new Vector();
    private boolean[] IsTotallVisible;
    boolean m_bClearOnce = false;
    public int m_iFocusedItemIndex = 0;
    int m_DisabledItemsNum = 0;
    boolean m_bIamLoading = true;
    int m_iInvisibleHeight = 0;
    int m_iInvisibleWidth = 0;
    int WidthError = 6;
    int iInitialTranslateWidth = 3;
    int iInitialTranslateHeight = 2;
    boolean m_bScrollFormBack = false;
    int m_iItemTobeDisplayed = 0;
    int m_LastVisibleItem = 0;
    boolean m_bMyFirstScroll = false;
    int m_TitleHeight = 0;
    boolean m_bIsFirstPaint = true;
    boolean m_DrawFocusRect = true;
    CustomComponent currComponent;
    boolean isLeftPressed = false;
    boolean isRightPressed = false;

    public void EnableTitleClock(boolean bIsDrawClock, IClockCalculator ClockCalc) {
        this.m_bIsDrawClock = bIsDrawClock;
        this.m_ClockCalc = ClockCalc;
        if (this.m_bIsDrawClock) {
            new Thread(new TitleClockRefresher(this)).start();
        }
    }

    public MobmeForm() {
        this.m_Height = this.getHeight();
        this.m_Width = this.getWidth() + 4;
    }

    public void setSetting() {
        this.iInitialTranslateWidth = 0;
        this.iInitialTranslateHeight = 0;
        this.WidthError = 0;
    }

    protected void paint(Graphics graphics) {
        if (this.m_bIsFirstPaint) {
            this.IsTotallVisible = new boolean[this.components.size()];
            this.m_bIsFirstPaint = false;
            this.GetNextValidItem(null);
            this.SaveVisibleItems();
        }
        try {
            this.CheckRepaintForAll();
            Font OldF = graphics.getFont();
            int h = this.getHeight();
            int w = this.getRealWidth();
            if (!this.m_bClearOnce) {
                this.SetFirstInvisibleItem();
                this.m_bClearOnce = true;
                int oldC = graphics.getColor();
                graphics.setColor(255, 255, 255);
                graphics.fillRect(0, 0, w, h);
                graphics.setColor(oldC);
            }
            graphics.translate(-this.m_iInvisibleWidth, -this.m_iInvisibleHeight);
            int iAccumulatedHeight = this.iInitialTranslateHeight;
            int iAccumulatedWidth = this.iInitialTranslateWidth;
            int iCounter = 0;
            this.GetValidFocusedItem();
            Enumeration e = this.components.elements();
            while (e.hasMoreElements()) {
                graphics.translate(iAccumulatedWidth, iAccumulatedHeight);
                CustomComponent nextComponent = (CustomComponent)((Object)e.nextElement());
                int iWidth = nextComponent.getMinContentWidth();
                int iHeight = nextComponent.getMinContentHeight();
                graphics.setClip(-1, -1, iWidth + 4, iHeight + 3);
                if (iCounter == this.m_iFocusedItemIndex) {
                    if (this.m_DrawFocusRect) {
                        graphics.drawRect(-1, -1, iWidth + 1, iHeight + 2);
                    }
                } else {
                    graphics.setColor(255, 255, 255);
                    graphics.drawRect(-1, -1, iWidth + 1, iHeight + 2);
                    graphics.setColor(0);
                }
                if (nextComponent.m_bIsNeedtorepaint) {
                    nextComponent.paint(graphics, iWidth, iHeight);
                }
                iAccumulatedHeight = iHeight + this.m_iPad;
                iAccumulatedWidth = 0;
                ++iCounter;
            }
            if (this.m_bIamLoading) {
                this.m_bIamLoading = false;
                CustomComponent FocusedItem = (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
                int[] visRect_inout = new int[4];
                this.PrepareNextFocusedItem(FocusedItem, visRect_inout);
            }
            graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
            graphics.setFont(OldF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void CheckRepaintForAll() {
        CustomComponent Comp;
        int iRepaintCount = 0;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            Comp = (CustomComponent)((Object)e.nextElement());
            if (!Comp.m_bIsNeedtorepaint) continue;
            ++iRepaintCount;
        }
        if (iRepaintCount == 0) {
            this.m_bClearOnce = false;
            this.m_bIamLoading = false;
            e = this.components.elements();
            while (e.hasMoreElements()) {
                Comp = (CustomComponent)((Object)e.nextElement());
                Comp.m_bIsNeedtorepaint = true;
            }
        }
    }

    public void commandAction(Command cmd, Displayable displayable) {
    }

    public void addCommand(String strCommandName, int CmdType) {
        this.CommandList.addElement(new Command(strCommandName, CmdType, 1));
        this.addCommand((Command)this.CommandList.elementAt(this.m_CommandNum));
        ++this.m_CommandNum;
    }

    public void append(CustomComponent component) {
        this.components.addElement(component);
        component.SetContainer(this);
        ++this.m_DisplayableNum;
    }

    public void SetFocusedItem(CustomComponent component) {
        CustomComponent nextComponent;
        int iIndex = 0;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements() && component != (nextComponent = (CustomComponent)((Object)e.nextElement()))) {
            ++iIndex;
        }
        this.m_iItemTobeDisplayed = this.m_iFocusedItemIndex = iIndex;
        if (this.m_iFocusedItemIndex != 0) {
            this.CheckInvisibleArea(this.m_iFocusedItemIndex);
        }
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void keyPressed(int keyCode) {
        boolean bGotDirection = this.ChangeFocus(keyCode);
        DEBUG = DEBUG + "..bGotDirection: " + bGotDirection + "\t\n";
        if (bGotDirection) {
            this.CheckInvisibleArea(this.m_iItemTobeDisplayed);
            this.repaint();
            return;
        }
        CustomComponent FocusedItem = (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
        FocusedItem.keyIsPressed(keyCode);
    }

    public void RefreshScreen() {
        this.m_bClearOnce = false;
        this.m_bIamLoading = true;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CustomComponent nextComponent = (CustomComponent)((Object)e.nextElement());
            nextComponent.m_bIsNeedtorepaint = true;
        }
        this.repaint();
    }

    boolean ChangeFocus(int iKeyCode) {
        try {
            CustomComponent FocusedItem = (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
            String str = this.getKeyName(iKeyCode);
            int[] visRect_inout = new int[]{0, 0, FocusedItem.getMinContentWidth(), FocusedItem.getMinContentHeight()};
            int ViewPortWidth = this.getWidth() + 2;
            int ViewPortHeight = this.getHeight();
            int[] iDirection = null;
            int keyAction = this.getGameAction(iKeyCode);
            if (iKeyCode > 48 && iKeyCode < 57 || iKeyCode == 35 || iKeyCode == 42) {
                keyAction = iKeyCode;
            }
            if (keyAction == 6) {
                iDirection = new int[]{6};
            }
            if (keyAction == 1) {
                iDirection = new int[]{1};
            }
            if (keyAction == 2) {
                iDirection = new int[]{2};
            }
            if (keyAction == 5) {
                iDirection = new int[]{5};
            }
            if (iDirection != null) {
                boolean bNext = FocusedItem.Traverse(iDirection[0], ViewPortWidth, ViewPortHeight, visRect_inout);
                if (!bNext) {
                    FocusedItem.m_bIsNeedtorepaint = true;
                    switch (iDirection[0]) {
                        case 6: {
                            if (this.GetNextValidItem(FocusedItem)) {
                                FocusedItem.TraverseOut();
                                FocusedItem = (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
                                this.PrepareNextFocusedItem(FocusedItem, visRect_inout);
                                FocusedItem.m_bIsNeedtorepaint = true;
                                this.m_iItemTobeDisplayed = this.m_iFocusedItemIndex;
                                break;
                            }
                            this.CheckDummyTraverseDown();
                            break;
                        }
                        case 1: {
                            if (this.GetPreviousValidItem(FocusedItem)) {
                                FocusedItem.TraverseOut();
                                FocusedItem = (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
                                this.PrepareNextFocusedItem(FocusedItem, visRect_inout);
                                FocusedItem.m_bIsNeedtorepaint = true;
                                this.m_iItemTobeDisplayed = this.m_iFocusedItemIndex;
                                break;
                            }
                            this.CheckDummyTraverseUp();
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception Err) {
            return false;
        }
    }

    public void DisableFocus(CustomComponent component) {
        this.DisabledItems.addElement(component);
        ++this.m_DisabledItemsNum;
    }

    boolean GetNextValidItem(CustomComponent component) {
        int iIndex;
        if (component == null) {
            return false;
        }
        for (iIndex = this.m_iFocusedItemIndex + 1; iIndex < this.m_DisplayableNum; ++iIndex) {
            CustomComponent NextItem = (CustomComponent)((Object)this.components.elementAt(iIndex));
            if (this.IsDisabledItem(NextItem)) {
                continue;
            }
            this.m_iItemTobeDisplayed = this.m_iFocusedItemIndex = iIndex;
            break;
        }
        return iIndex < this.m_DisplayableNum;
    }

    boolean GetPreviousValidItem(CustomComponent component) {
        int iIndex;
        if (component == null) {
            return false;
        }
        for (iIndex = this.m_iFocusedItemIndex - 1; iIndex >= 0; --iIndex) {
            CustomComponent NextItem = (CustomComponent)((Object)this.components.elementAt(iIndex));
            if (this.IsDisabledItem(NextItem)) {
                continue;
            }
            this.m_iItemTobeDisplayed = this.m_iFocusedItemIndex = iIndex;
            break;
        }
        return iIndex >= 0;
    }

    boolean IsDisabledItem(CustomComponent component) {
        if (this.DisabledItems.size() == this.components.size()) {
            return false;
        }
        Enumeration e = this.DisabledItems.elements();
        while (e.hasMoreElements()) {
            CustomComponent DisabledComponent = (CustomComponent)((Object)e.nextElement());
            if (component != DisabledComponent) continue;
            return true;
        }
        return false;
    }

    void PrepareNextFocusedItem(CustomComponent component, int[] visRect_inout) {
        visRect_inout = new int[]{0, 0, component.getMinContentWidth(), component.getMinContentHeight()};
    }

    void CheckInvisibleArea(int iComparableIndex) {
        CustomComponent Component;
        int iIndex;
        if (iComparableIndex >= this.m_DisplayableNum || iComparableIndex < 0) {
            return;
        }
        if (this.VisibleComponents.size() > 0) {
            Enumeration e = this.VisibleComponents.elements();
            while (e.hasMoreElements()) {
                CustomComponent VisibleItem = (CustomComponent)((Object)e.nextElement());
                if (VisibleItem != (CustomComponent)((Object)this.components.elementAt(iComparableIndex)) || !this.IsTotallVisible[iComparableIndex]) continue;
                return;
            }
        }
        int iAccHeight = this.iInitialTranslateHeight;
        for (iIndex = 0; iIndex <= iComparableIndex; ++iIndex) {
            Component = (CustomComponent)((Object)this.components.elementAt(iIndex));
            iAccHeight = iAccHeight + Component.getMinContentHeight() + this.m_iPad;
        }
        if (iAccHeight > this.getHeight()) {
            this.m_bScrollFormBack = true;
            this.m_bClearOnce = false;
            this.m_iInvisibleHeight = iAccHeight - this.getHeight();
            for (iIndex = 0; iIndex <= iComparableIndex; ++iIndex) {
                Component = (CustomComponent)((Object)this.components.elementAt(iIndex));
                Component.m_bIsNeedtorepaint = true;
            }
        } else {
            this.m_iInvisibleHeight = 0;
            if (this.m_bScrollFormBack) {
                this.m_bScrollFormBack = false;
                this.m_bClearOnce = false;
                int iHeight = this.iInitialTranslateHeight;
                iIndex = 0;
                while (iHeight < this.getHeight()) {
                    CustomComponent Component2 = (CustomComponent)((Object)this.components.elementAt(iIndex));
                    iHeight += Component2.getMinContentHeight() + this.m_iPad;
                    Component2.m_bIsNeedtorepaint = true;
                    ++iIndex;
                }
            }
        }
        this.SaveVisibleItems();
    }

    protected void keyReleased(int keyCode) {
        CustomComponent FocusedItem = (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
        FocusedItem.keyIsReleased(keyCode);
    }

    public int getWidth() {
        int retValue = super.getWidth();
        return retValue - this.WidthError;
    }

    void GetValidFocusedItem() {
        if (!this.IsDisabledItem((CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex)))) {
            return;
        }
        if (this.m_iFocusedItemIndex < this.m_DisplayableNum && !this.GetNextValidItem((CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex))) && !this.GetPreviousValidItem((CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex)))) {
            this.m_iFocusedItemIndex = 0;
        }
        this.SetFocusedItem((CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex)));
    }

    boolean ApplyFocus(CustomComponent item) {
        if (this.IsDisabledItem(item)) {
            return false;
        }
        this.SetFocusedItem(item);
        return true;
    }

    void CheckDummyTraverseDown() {
        if (this.m_bMyFirstScroll) {
            this.m_bMyFirstScroll = false;
            if (this.m_iItemTobeDisplayed < this.m_LastVisibleItem) {
                this.m_iItemTobeDisplayed = this.m_LastVisibleItem;
            }
        }
        this.m_iItemTobeDisplayed = this.m_iItemTobeDisplayed < this.m_DisplayableNum - 1 ? ++this.m_iItemTobeDisplayed : this.m_DisplayableNum - 1;
    }

    void CheckDummyTraverseUp() {
        this.m_iItemTobeDisplayed = this.m_iItemTobeDisplayed > 0 ? --this.m_iItemTobeDisplayed : 0;
    }

    void SetFirstInvisibleItem() {
        int iIndex;
        int iAccHeight = 0;
        this.m_bMyFirstScroll = true;
        for (iIndex = 0; iAccHeight < this.getHeight() && iIndex < this.m_DisplayableNum; ++iIndex) {
            CustomComponent Component = (CustomComponent)((Object)this.components.elementAt(iIndex));
            iAccHeight = iAccHeight + Component.getMinContentHeight() + this.m_iPad;
        }
        this.m_LastVisibleItem = iIndex < this.m_DisplayableNum ? iIndex - 1 : this.m_DisplayableNum - 1;
    }

    public int getRealHeight() {
        int retValue = super.getHeight();
        return retValue;
    }

    public int getRealWidth() {
        int retValue = super.getWidth();
        return retValue;
    }

    protected void pointerReleased(int x, int y) {
        if (y > this.getHeight() + this.m_TitleHeight + 1) {
            return;
        }
        if (x >= 0 && x <= this.getWidth()) {
            int iAccHeight = this.iInitialTranslateHeight + this.m_TitleHeight + 1 - this.m_iInvisibleHeight;
            int iPreviousItemsHeight = this.iInitialTranslateHeight + this.m_TitleHeight + 1 - this.m_iInvisibleHeight;
            Enumeration e = this.components.elements();
            while (e.hasMoreElements()) {
                CustomComponent nextComponent = (CustomComponent)((Object)e.nextElement());
                if (this.currComponent instanceof MobmeChoice && this.currComponent == nextComponent) {
                    if (this.isLeftPressed) {
                        this.keyReleased(this.getKeyCode(2));
                    } else if (this.isRightPressed) {
                        this.keyReleased(this.getKeyCode(5));
                    }
                } else if (this.currComponent instanceof MobmeNumChoice && this.currComponent == nextComponent) {
                    if (this.isLeftPressed) {
                        this.keyReleased(this.getKeyCode(2));
                    } else if (this.isRightPressed) {
                        this.keyReleased(this.getKeyCode(5));
                    }
                }
                int iItemHeight = nextComponent.getMinContentHeight();
                if (y > iPreviousItemsHeight && y <= (iAccHeight += iItemHeight)) {
                    nextComponent.pointerReleased(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight);
                    return;
                }
                iPreviousItemsHeight = iAccHeight + this.m_iPad;
                iAccHeight += this.m_iPad;
            }
        }
    }

    void SaveVisibleItems() {
        if (this.VisibleComponents.size() > 0) {
            this.VisibleComponents.removeAllElements();
        }
        if (this.components.size() == 0) {
            return;
        }
        int iAccHeight = this.iInitialTranslateHeight;
        int iTraslatedHeight = -this.m_iInvisibleHeight;
        int iIndex = 0;
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            CustomComponent nextComponent = (CustomComponent)((Object)e.nextElement());
            int iItemHeight = nextComponent.getMinContentHeight();
            if ((iTraslatedHeight += (iAccHeight += iItemHeight)) >= 0 && iTraslatedHeight - iItemHeight <= this.getHeight()) {
                this.IsTotallVisible[iIndex] = iTraslatedHeight - iItemHeight < 0 ? false : iTraslatedHeight <= this.getHeight();
                this.VisibleComponents.addElement(this.components.elementAt(iIndex));
            }
            iAccHeight = this.m_iPad;
            if (iTraslatedHeight >= this.getHeight()) break;
            ++iIndex;
        }
    }

    protected void pointerDragged(int x, int y) {
        if (y > this.getHeight() + this.m_TitleHeight + 1) {
            return;
        }
        if (x >= 0 && x <= this.getWidth()) {
            int iAccHeight = this.iInitialTranslateHeight + this.m_TitleHeight + 1 - this.m_iInvisibleHeight;
            int iPreviousItemsHeight = this.iInitialTranslateHeight + this.m_TitleHeight + 1 - this.m_iInvisibleHeight;
            Enumeration e = this.components.elements();
            while (e.hasMoreElements()) {
                CustomComponent nextComponent = (CustomComponent)((Object)e.nextElement());
                int iItemHeight = nextComponent.getMinContentHeight();
                if (y > iPreviousItemsHeight && y <= (iAccHeight += iItemHeight)) {
                    nextComponent.pointerDragged(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight);
                    return;
                }
                iPreviousItemsHeight = iAccHeight + this.m_iPad;
                iAccHeight += this.m_iPad;
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        this.isLeftPressed = false;
        this.isRightPressed = false;
        if (y > this.getHeight() + this.m_TitleHeight + 1) {
            return;
        }
        if (x >= 0 && x <= this.getWidth()) {
            int iAccHeight = this.iInitialTranslateHeight + this.m_TitleHeight + 1 - this.m_iInvisibleHeight;
            int iPreviousItemsHeight = this.iInitialTranslateHeight + this.m_TitleHeight + 1 - this.m_iInvisibleHeight;
            Enumeration e = this.components.elements();
            while (e.hasMoreElements()) {
                CustomComponent nextComponent = (CustomComponent)((Object)e.nextElement());
                int iItemHeight = nextComponent.getMinContentHeight();
                if (y > iPreviousItemsHeight && y <= (iAccHeight += iItemHeight)) {
                    nextComponent.pointerPressed(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight);
                    nextComponent.rePaint();
                    if (nextComponent instanceof MobmeChoice && this.currComponent == nextComponent) {
                        if (((MobmeChoice)nextComponent).isLeftScroll(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight)) {
                            this.isLeftPressed = true;
                            this.keyPressed(this.getKeyCode(2));
                        } else if (((MobmeChoice)nextComponent).isRightScroll(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight)) {
                            this.isRightPressed = true;
                            this.keyPressed(this.getKeyCode(5));
                        } else {
                            nextComponent.keyIsPressed(this.getKeyCode(8));
                        }
                    } else if (nextComponent instanceof MobmeNumChoice && this.currComponent == nextComponent) {
                        if (((MobmeNumChoice)nextComponent).isLeftScroll(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight)) {
                            this.isLeftPressed = true;
                            this.keyPressed(this.getKeyCode(2));
                        } else if (((MobmeNumChoice)nextComponent).isRightScroll(x - this.iInitialTranslateWidth, y - iPreviousItemsHeight)) {
                            this.isRightPressed = true;
                            this.keyPressed(this.getKeyCode(5));
                        } else {
                            nextComponent.keyIsPressed(this.getKeyCode(8));
                        }
                    }
                    this.currComponent = nextComponent;
                    return;
                }
                iPreviousItemsHeight = iAccHeight + this.m_iPad;
                iAccHeight += this.m_iPad;
            }
        }
    }

    public CustomComponent GetFocusedItem() {
        return (CustomComponent)((Object)this.components.elementAt(this.m_iFocusedItemIndex));
    }

    public void DisableFocusRect() {
        this.m_DrawFocusRect = false;
    }

    public void EnableFocusRect() {
        this.m_DrawFocusRect = true;
    }

    public void setTitle(String s) {
        super.setTitle(s);
    }

    public void SetRawTitle(String s) {
        this.m_RawTitle = s;
        if (this.m_ClockCalc == null || !this.m_bIsDrawClock) {
            return;
        }
        this.setTitle(this.m_RawTitle + "-" + this.m_ClockCalc.getCurrentTime());
    }

    public static class TitleClockRefresher
    implements Runnable {
        MobmeForm m_Parent;

        TitleClockRefresher(MobmeForm Parent) {
            this.m_Parent = Parent;
        }

        public void run() {
            if (this.m_Parent.m_ClockCalc == null) {
                return;
            }
            while (this.m_Parent.m_bIsDrawClock) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.m_Parent.setTitle(this.m_Parent.m_RawTitle + "-" + this.m_Parent.m_ClockCalc.getCurrentTime());
            }
        }
    }
}

