/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.CustomComponent;
import MobmeControls.I18NSubSupport;
import MobmeControls.MobmeChoiceListener;
import MobmeControls.MobmeEdit;
import MobmeControls.MobmeForm;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextBox;

public class MobmeNumChoice
extends CustomComponent
implements CommandListener,
Runnable {
    String m_strLabel = "";
    String m_strTitle = "";
    int m_iStartNo = -1;
    int m_iEndNo = -1;
    int m_nSize = -1;
    Displayable m_Parent = null;
    MobmeChoiceListener m_SelListener = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    Font m_F;
    boolean m_bIsRightPressed = false;
    boolean m_bIsLeftPressed = false;
    boolean m_bIsTraversedOut = true;
    boolean m_bIsLocked = false;
    int m_iPos;
    MobmeForm m_EditForm = null;
    MobmeEdit m_EditCtrl = null;
    boolean Nokia_S40 = false;
    int xUnit = 0;
    int yUnit = 0;
    int TrWidth = 0;
    int arrH = 0;
    int Width = 0;
    TextEditor txtEditor = null;

    public MobmeNumChoice(String Title, Displayable parent, Display display, Font f, boolean bIsArabic, int iStartNo, int iEndNo) {
        String result = System.getProperty("microedition.platform");
        if (result != null && result.startsWith("Nokia") && System.getProperty("com.nokia.mid.timeformat") != null) {
            this.Nokia_S40 = true;
        }
        this.m_strTitle = Title;
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_iPos = -1;
        this.m_iStartNo = iStartNo;
        this.m_iEndNo = iEndNo;
        this.m_nSize = this.m_iEndNo - this.m_iStartNo + 1;
        this.m_EditForm = new MobmeForm();
        this.m_EditForm.addCommand(new Command(I18NSubSupport.getMessage("Back"), 2, 0));
        this.m_EditForm.addCommand(new Command(I18NSubSupport.getMessage("Done"), 4, 1));
        if (this.Nokia_S40) {
            this.m_EditForm.addCommand(new Command(I18NSubSupport.getMessage("Clear"), 4, 0));
        }
        this.m_EditCtrl = new MobmeEdit("", (Displayable)this.m_EditForm, display, f, bIsArabic);
        this.m_EditCtrl.SetNumberInputMode(true);
        this.m_EditForm.append(this.m_EditCtrl);
        this.m_EditForm.setTitle(I18NSubSupport.getMessage("EnterN"));
        this.m_EditForm.setCommandListener(this);
    }

    public void setSelListener(MobmeChoiceListener SelListener) {
        this.m_SelListener = SelListener;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    public boolean isLeftScroll(int X, int Y) {
        int xorigin;
        return this.m_bIsArabic ? X > this.xUnit && X <= this.TrWidth + this.xUnit + 2 && Y > this.yUnit && Y <= this.arrH + this.yUnit : X > (xorigin = this.Width - (this.TrWidth * 2 + this.xUnit + this.xUnit * 3) - 5) + this.xUnit + 2 && X < xorigin + this.TrWidth + this.xUnit + 2 && Y > this.yUnit && Y < this.arrH + this.yUnit;
    }

    public boolean isRightScroll(int X, int Y) {
        int xorigin;
        return this.m_bIsArabic ? X > this.TrWidth + this.xUnit + 2 && X <= 2 * this.TrWidth + this.xUnit + 4 && Y > this.yUnit && Y <= this.arrH + this.yUnit : X > (xorigin = this.Width - (this.TrWidth * 2 + this.xUnit + this.xUnit * 3) - 5) + this.TrWidth + this.xUnit + 2 && X < xorigin + 2 * this.TrWidth + this.xUnit + 4 && Y > this.yUnit && Y < this.arrH + this.yUnit;
    }

    protected int getMinContentHeight() {
        return this.m_F.getHeight() + 4;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_F.getHeight() + 4;
    }

    protected void paint(Graphics graphics, int w, int h) {
        if (this.m_bIsLocked) {
            return;
        }
        int oldC = graphics.getColor();
        graphics.setColor(15266040);
        graphics.fillRect(0, 0, w, h);
        graphics.setColor(0);
        graphics.drawRect(1, 1, w - 5, h - 2);
        this.arrH = h;
        this.Width = w;
        this.xUnit = 3;
        this.yUnit = 3;
        this.TrWidth = (h - 4) / 2;
        if (this.m_bIsArabic) {
            if (this.m_bIsLeftPressed) {
                graphics.setColor(3951458);
                graphics.fillRect(this.xUnit - 1, this.yUnit - 1, this.TrWidth + this.xUnit + 2, h - 2 * this.yUnit + 3);
                graphics.setColor(15266040);
            } else {
                graphics.setColor(3951458);
            }
            graphics.fillTriangle(this.xUnit, h / 2, this.TrWidth + this.xUnit, this.yUnit, this.TrWidth + this.xUnit, h - this.yUnit);
            if (this.m_bIsRightPressed) {
                graphics.setColor(3951458);
                graphics.fillRect(this.TrWidth + this.xUnit + this.xUnit, this.yUnit - 1, this.TrWidth + this.xUnit + 2, h - 2 * this.yUnit + 3);
                graphics.setColor(15266040);
            } else {
                graphics.setColor(3951458);
            }
            graphics.fillTriangle(this.TrWidth + this.xUnit + this.xUnit * 2, this.yUnit, this.TrWidth + this.xUnit + this.xUnit * 2, h - this.yUnit, this.TrWidth * 2 + this.xUnit + this.xUnit * 2, h / 2);
        } else {
            int xorigin = w - (this.TrWidth * 2 + this.xUnit + this.xUnit * 3) - 5;
            if (this.m_bIsLeftPressed) {
                graphics.setColor(3951458);
                graphics.fillRect(xorigin + this.xUnit - 1, this.yUnit - 1, this.TrWidth + this.xUnit + 2, h - 2 * this.yUnit + 3);
                graphics.setColor(15266040);
            } else {
                graphics.setColor(3951458);
            }
            graphics.fillTriangle(xorigin + this.xUnit, h / 2, xorigin + this.TrWidth + this.xUnit, this.yUnit, xorigin + this.TrWidth + this.xUnit, h - this.yUnit);
            if (this.m_bIsRightPressed) {
                graphics.setColor(3951458);
                graphics.fillRect(xorigin + this.TrWidth + this.xUnit + this.xUnit, this.yUnit - 1, this.TrWidth + this.xUnit + 2, h - 2 * this.yUnit + 3);
                graphics.setColor(15266040);
            } else {
                graphics.setColor(3951458);
            }
            graphics.fillTriangle(xorigin + this.TrWidth + this.xUnit + this.xUnit * 2, this.yUnit, xorigin + this.TrWidth + this.xUnit + this.xUnit * 2, h - this.yUnit, xorigin + this.TrWidth * 2 + this.xUnit + this.xUnit * 2, h / 2);
        }
        graphics.setColor(oldC);
        if (this.m_iPos == -1) {
            return;
        }
        if (this.m_iPos < 0 || this.m_iPos >= this.m_nSize) {
            return;
        }
        this.m_strLabel = Integer.toString(this.m_iStartNo + this.m_iPos);
        if (this.m_strLabel == "") {
            return;
        }
        if (this.m_bIsArabic) {
            graphics.setClip(this.TrWidth * 2 + this.xUnit + this.xUnit * 2 + 2, this.yUnit, w - (this.TrWidth * 2 + this.xUnit + this.xUnit * 2 + 4) - 5, h - this.yUnit * 2);
            graphics.drawString(this.m_strLabel, w - 8, 1, 24);
        } else {
            graphics.setClip(2, this.yUnit, w - (this.TrWidth * 2 + this.xUnit + this.xUnit * 3), h - this.yUnit * 2);
            graphics.drawString(this.m_strLabel, 5, 0, 20);
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.m_bIsLeftPressed = false;
        this.m_bIsRightPressed = false;
        switch (dir) {
            case 6: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                this.m_bIsLeftPressed = true;
                if (this.m_iPos < this.m_nSize - 1) {
                    ++this.m_iPos;
                }
                this.rePaint();
                new Thread(this).start();
                break;
            }
            case 5: {
                this.m_bIsRightPressed = true;
                if (this.m_iPos > 0) {
                    --this.m_iPos;
                }
                this.rePaint();
                new Thread(this).start();
            }
        }
        return true;
    }

    protected void traverseOut() {
        this.m_bIsTraversedOut = true;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8 || keyAction == 53) {
            String stre = "";
            stre = Integer.toString(this.m_iPos + this.m_iStartNo);
            this.m_EditCtrl.SetString(stre);
            this.m_Display.setCurrent((Displayable)this.m_EditForm);
            this.m_EditForm.RefreshScreen();
        }
    }

    protected void keyReleased(int keyCode) {
        this.m_bIsLeftPressed = false;
        this.m_bIsRightPressed = false;
        this.rePaint();
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if ((keyAction == 2 || keyAction == 5) && this.m_SelListener != null) {
            this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
        }
    }

    protected void keyRepeated(int keyCode) {
    }

    public void SetPos(int iPos) {
        if (iPos < 0 || iPos >= this.m_nSize) {
            return;
        }
        this.m_iPos = iPos;
        this.rePaint();
    }

    public int GetPos() {
        return this.m_iPos;
    }

    public int GetValue() {
        return this.m_iStartNo + this.m_iPos;
    }

    public String GetString(int iPos) {
        if (iPos < 0 || iPos >= this.m_nSize) {
            return "";
        }
        return Integer.toString(this.m_iPos + this.m_iStartNo);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.m_EditForm || displayable instanceof TextBox) {
            if (command.getCommandType() == 4 && command.getPriority() == 1) {
                int iVal;
                String stre = this.m_EditCtrl.GetString();
                if (displayable instanceof TextBox) {
                    stre = this.txtEditor.getString();
                }
                try {
                    iVal = Integer.parseInt(stre);
                }
                catch (Throwable ex) {
                    iVal = 1;
                }
                if (iVal >= this.m_iStartNo && iVal < this.m_nSize + this.m_iStartNo) {
                    this.m_iPos = iVal - this.m_iStartNo;
                    this.m_Display.setCurrent(this.m_Parent);
                    try {
                        MobmeForm frm = (MobmeForm)this.m_Parent;
                        frm.RefreshScreen();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (this.m_SelListener != null) {
                        this.m_SelListener.OnSelectionChanged((Item)this, this.m_iPos);
                    }
                }
            } else if (command.getCommandType() == 4 && command.getPriority() == 0) {
                this.m_EditCtrl.keyPressed(35);
            } else if (command.getCommandType() == 2 && command.getPriority() == 0) {
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    MobmeForm frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        while (this.m_bIsLeftPressed || this.m_bIsRightPressed) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            if (this.m_bIsLeftPressed) {
                if (this.m_iPos < this.m_nSize - 1) {
                    ++this.m_iPos;
                }
                this.rePaint();
                continue;
            }
            if (!this.m_bIsRightPressed) break;
            if (this.m_iPos > 0) {
                --this.m_iPos;
            }
            this.rePaint();
        }
    }

    public void Reset(int iStartNo, int iEndNo) {
        this.m_iStartNo = iStartNo;
        this.m_iEndNo = iEndNo;
        this.m_nSize = this.m_iEndNo - this.m_iStartNo + 1;
        this.m_iPos = 0;
    }

    public void Lock(boolean bIsLocked) {
        this.m_bIsLocked = bIsLocked;
        if (!bIsLocked) {
            this.rePaint();
        }
    }

    class TextEditor
    extends TextBox {
        Command cmd_back = new Command("Back", 2, 0);
        Command cmd_ok = new Command("Ok", 4, 1);
        Displayable backscrn = null;

        public TextEditor(CommandListener cmdlistener, String content) {
            super(MobmeNumChoice.this.m_strLabel, content, 15, 2);
            this.addCommand(this.cmd_ok);
            this.addCommand(this.cmd_back);
            this.setCommandListener(cmdlistener);
        }
    }
}

