/*
 * Decompiled with CFR 0.152.
 */
package DictPKG;

import GeneralLibs.CustomInputStream;
import GeneralLibs.GeneralUtils;

public abstract class HelpFunctions {
    public static char[] cp1256_to_unicode_tab = new char[]{'\u20ac', '\u067e', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0679', '\u2039', '\u0152', '\u0686', '\u0698', '\u0688', '\u06af', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u06a9', '\u2122', '\u0691', '\u203a', '\u0153', '\u200c', '\u200d', '\u06ba', '\u00a0', '\u060c', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u06be', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u061b', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u061f', '\u06c1', '\u0621', '\u0622', '\u0623', '\u0624', '\u0625', '\u0626', '\u0627', '\u0628', '\u0629', '\u062a', '\u062b', '\u062c', '\u062d', '\u062e', '\u062f', '\u0630', '\u0631', '\u0632', '\u0633', '\u0634', '\u0635', '\u0636', '\u00d7', '\u0637', '\u0638', '\u0639', '\u063a', '\u0640', '\u0641', '\u0642', '\u0643', '\u00e0', '\u0644', '\u00e2', '\u0645', '\u0646', '\u0647', '\u0648', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u0649', '\u064a', '\u00ee', '\u00ef', '\u064b', '\u064c', '\u064d', '\u064e', '\u00f4', '\u064f', '\u0650', '\u00f7', '\u0651', '\u00f9', '\u0652', '\u00fb', '\u00fc', '\u200e', '\u200f', '\u00ff'};

    public static void ReadCharArray(CustomInputStream hFile, char[] chrArray) {
        try {
            if (hFile != null) {
                for (int iCount = 0; iCount < chrArray.length; ++iCount) {
                    chrArray[iCount] = (char)GeneralUtils.hton(hFile.readShort());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int ReadIntArray(CustomInputStream hFile, int[] IntArray, int inum) {
        try {
            if (hFile != null) {
                for (int iCount = 0; iCount < inum; ++iCount) {
                    IntArray[iCount] = GeneralUtils.htonl(hFile.readInt());
                }
            }
            return 0;
        }
        catch (Exception Ex) {
            return -1;
        }
    }

    public static int ArabicMultiByteToWideChar(short CodePage, int dwFlags, char[] lpMultiByteStr, int cbMultiByte, char[] lpWideCharStr, int cchWideChar) {
        int nLen;
        int nRet = 0;
        if (lpMultiByteStr == null || cbMultiByte == 0) {
            return nRet;
        }
        String szlpMultiByteStr = new String(lpMultiByteStr);
        int n = nLen = cbMultiByte == -1 ? szlpMultiByteStr.length() : cbMultiByte;
        if (cchWideChar == 0) {
            return nLen;
        }
        for (int i = 0; i < cchWideChar; ++i) {
            lpWideCharStr[i] = HelpFunctions.cp1256_to_unicode(lpMultiByteStr[i]);
        }
        return nLen;
    }

    public static int InternalMultiByteToWideChar(short CodePage, int dwFlags, char[] lpMultiByteStr, int cbMultiByte, char[] lpWideCharStr, int cchWideChar) {
        switch (CodePage) {
            case 1256: {
                return HelpFunctions.ArabicMultiByteToWideChar(CodePage, dwFlags, lpMultiByteStr, cbMultiByte, lpWideCharStr, cchWideChar);
            }
        }
        String strTemp = String.valueOf(lpMultiByteStr);
        strTemp.getChars(0, cbMultiByte, lpWideCharStr, 0);
        return 0;
    }

    public static char cp1256_to_unicode(char ch) {
        if (ch >= '\u0080' && ch <= '\u00ff') {
            return cp1256_to_unicode_tab[ch - 128];
        }
        return ch;
    }

    public static int MyParseInt(String str) {
        char c;
        String strPart = new String("");
        int i = -1;
        int j = 0;
        while (j < str.length() && (c = str.charAt(j++)) != '\u0000' && c >= '0' && c <= '9') {
            strPart = strPart + c;
        }
        try {
            i = Integer.parseInt(strPart);
        }
        catch (Exception e) {
            i = -1;
        }
        return i;
    }

    public static byte tolower(byte Dat) {
        if (Dat >= 65 && Dat <= 97) {
            Dat = (byte)(Dat + 32);
        }
        return Dat;
    }

    public static void strncpyByte(byte[] Dst, int DstIndex, byte[] Src, int SrcIndex, int nCpyNum) {
        for (int iCount = 0; iCount < nCpyNum; ++iCount) {
            byte Temp;
            Dst[DstIndex + iCount] = Temp = Src[SrcIndex + iCount];
        }
    }

    public static void BytetoCharArray(char[] chrArr, int iCharIndex, byte[] ByteArr, int iByteIndex, int nCpyNum) {
        for (int iCount = 0; iCount < nCpyNum; ++iCount) {
            chrArr[iCount + iCharIndex] = (char)ByteArr[iCount + iByteIndex];
        }
    }

    public static void CharToByteArray(byte[] ByteArr, int iByteIndex, char[] CharArr, int iChrIndex, int nCpyNum) {
        for (int iCount = 0; iCount < nCpyNum; ++iCount) {
            ByteArr[iCount + iByteIndex] = (byte)(CharArr[iCount + iChrIndex] & 0xFF);
        }
    }
}

