/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class VideoSplashScreen
extends Canvas {
    private static final int DEFAULT_TIMEOUT = 5000;
    private int timeout = 5000;
    private boolean allowTimeoutInterrupt = true;
    private long currentDisplayTimestamp;
    private Image m_Image;
    private Display display;
    private String text;
    private Font DEFAULT_TEXT_FONT;
    private Font textFont = this.DEFAULT_TEXT_FONT = Font.getFont((int)0);
    private Display previouslyShownDisplayable;
    private Displayable nextDisplayable;
    private Displayable previousDisplayable;
    public Player m_Player;
    VideoControl m_VideoControl;
    int m_BackColor = 0xFFFFFF;
    private Display m_Display;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAllowTimeoutInterrupt(boolean allow) {
        this.allowTimeoutInterrupt = allow;
    }

    public boolean isAllowTimeoutInterrupt() {
        return this.allowTimeoutInterrupt;
    }

    protected void keyPressed(int keyCode) {
        this.userAction();
    }

    protected void pointerPressed(int x, int y) {
        this.userAction();
    }

    private void userAction() {
        if (this.allowTimeoutInterrupt) {
            this.switchToNextDisplayable();
        }
    }

    public void timeout() {
        this.switchToNextDisplayable();
    }

    public void setNextDisplayable(Displayable nextDisplayable) {
        this.nextDisplayable = nextDisplayable;
    }

    protected void sizeChanged(int w, int h) {
        this.repaint();
    }

    protected Display getDisplay() {
        return this.display;
    }

    protected Displayable getNextDisplayable() {
        return this.nextDisplayable;
    }

    protected void switchToNextDisplayable() {
        if (this.nextDisplayable != null) {
            VideoSplashScreen.switchToDisplayable(this.display, null, this.nextDisplayable);
        } else if (this.previousDisplayable != null) {
            this.display.setCurrent(this.previousDisplayable);
        }
    }

    protected static void switchToDisplayable(Display display, Alert alert, Displayable displayable) {
        if (displayable != null) {
            if (alert != null) {
                display.setCurrent(alert, displayable);
            } else {
                display.setCurrent(displayable);
            }
        }
    }

    private String[] splitURL(String url) throws Exception {
        int slash;
        StringBuffer u = new StringBuffer(url);
        String[] result = new String[6];
        for (int i = 0; i <= 5; ++i) {
            result[i] = "";
        }
        boolean protFound = false;
        int index = url.indexOf(":");
        if (index > 0) {
            result[0] = url.substring(0, index);
            u.delete(0, index + 1);
            protFound = true;
        } else if (index == 0) {
            throw new Exception("url format error - protocol");
        }
        if (u.length() > 2 && u.charAt(0) == '/' && u.charAt(1) == '/') {
            u.delete(0, 2);
            slash = u.toString().indexOf(47);
            if (slash < 0) {
                slash = u.length();
            }
            int colon = u.toString().indexOf(58);
            int endIndex = slash;
            if (colon >= 0) {
                if (colon > slash) {
                    throw new Exception("url format error - port");
                }
                endIndex = colon;
                result[2] = u.toString().substring(colon + 1, slash);
            }
            result[1] = u.toString().substring(0, endIndex);
            u.delete(0, slash);
        }
        if (u.length() > 0) {
            url = u.toString();
            slash = url.lastIndexOf(47);
            if (slash > 0) {
                result[3] = url.substring(0, slash);
            }
            if (slash < url.length() - 1) {
                String fn = url.substring(slash + 1, url.length());
                int anchorIndex = fn.indexOf("#");
                if (anchorIndex >= 0) {
                    result[4] = fn.substring(0, anchorIndex);
                    result[5] = fn.substring(anchorIndex + 1);
                } else {
                    result[4] = fn;
                }
            }
        }
        return result;
    }

    private String guessContentType(String url) throws Exception {
        String[] sURL = this.splitURL(url);
        String ext = "";
        String ct = "";
        int lastDot = sURL[4].lastIndexOf(46);
        if (lastDot >= 0) {
            ext = sURL[4].substring(lastDot + 1).toLowerCase();
        }
        if (ext.equals("mpg") || url.equals("avi")) {
            ct = "video/mpeg";
        } else if (ext.equals("mid") || ext.equals("kar")) {
            ct = "audio/midi";
        } else if (ext.equals("wav")) {
            ct = "audio/x-wav";
        } else if (ext.equals("jts")) {
            ct = "audio/x-tone-seq";
        } else if (ext.equals("txt")) {
            ct = "audio/x-txt";
        } else if (ext.equals("amr")) {
            ct = "audio/amr";
        } else if (ext.equals("awb")) {
            ct = "audio/amr-wb";
        } else if (ext.equals("gif")) {
            ct = "image/gif";
        }
        return ct;
    }

    public VideoSplashScreen(Display display) {
        this.display = display;
        this.m_Display = display;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public boolean open(String url, int loopCnt, int BackColor) {
        try {
            if (this.m_Player != null) {
                this.m_Player.stop();
                this.m_Player.close();
            }
            this.m_Player = null;
            throw new Exception();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.m_Player == null && url.startsWith("resource:")) {
                try {
                    this.m_Image = Image.createImage((String)url.substring(9));
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    protected void showNotify() {
        this.previousDisplayable = this.getDisplay().getCurrent();
        this.currentDisplayTimestamp = System.currentTimeMillis();
        if (this.timeout > 0) {
            Watchdog w = new Watchdog(this.timeout, this.currentDisplayTimestamp);
            w.start();
        }
    }

    protected void hideNotify() {
        this.currentDisplayTimestamp = System.currentTimeMillis();
        if (this.m_Player == null) {
            return;
        }
        try {
            this.m_Player.stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    protected void paint(Graphics g) {
        g.setColor(this.m_BackColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.m_Display.getColor(1));
        if (this.m_Image != null && this.m_VideoControl == null) {
            g.drawImage(this.m_Image, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        if (this.text != null) {
            if (this.m_VideoControl != null) {
                g.drawString(this.text, this.getWidth() / 2, this.m_VideoControl.getDisplayY() + this.m_VideoControl.getDisplayHeight() + 10, 17);
            } else if (this.m_Image != null) {
                g.drawString(this.text, this.getWidth() / 2, (this.getHeight() - this.m_Image.getHeight()) / 2 + this.m_Image.getHeight() + 10, 17);
            } else {
                g.drawString(this.text, this.getWidth() / 2, this.getHeight() / 2, 65);
            }
        }
    }

    private class Watchdog
    extends Thread {
        private int timeout;
        private long currentDisplayTimestamp;

        private Watchdog(int timeout, long currentDisplayTimestamp) {
            this.timeout = timeout;
            this.currentDisplayTimestamp = currentDisplayTimestamp;
        }

        public void run() {
            if (VideoSplashScreen.this.m_Player != null) {
                try {
                    VideoSplashScreen.this.m_Player.start();
                }
                catch (MediaException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.currentDisplayTimestamp == VideoSplashScreen.this.currentDisplayTimestamp) {
                VideoSplashScreen.this.timeout();
            }
        }
    }
}

